/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.licensor.interfaces.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicensingCharsets;
import net.nicholaswilliams.java.licensing.encryption.FilePrivateKeyDataProvider;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PrivateKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import net.nicholaswilliams.java.licensing.exception.ObjectSerializationException;
import net.nicholaswilliams.java.licensing.licensor.LicenseCreator;
import net.nicholaswilliams.java.licensing.licensor.LicenseCreatorProperties;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.ConsoleUtilities;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi.CliOptionsBuilder;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi.TextInterfaceDevice;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;

public class ConsoleLicenseGenerator {
    public static final String PROPERTY_PRIVATE_KEY_FILE = "net.nicholaswilliams.java.licensing.privateKeyFile";
    public static final String PROPERTY_PRIVATE_KEY_PROVIDER = "net.nicholaswilliams.java.licensing.privateKeyProvider";
    public static final String PROPERTY_PRIVATE_KEY_PASSWORD = "net.nicholaswilliams.java.licensing.privateKeyPassword";
    public static final String PROPERTY_PRIVATE_KEY_PASSWORD_PROVIDER = "net.nicholaswilliams.java.licensing.privateKeyPasswordProvider";
    public static final String PROPERTY_LICENSE_PRODUCT_KEY = "net.nicholaswilliams.java.licensing.productKey";
    public static final String PROPERTY_LICENSE_HOLDER = "net.nicholaswilliams.java.licensing.holder";
    public static final String PROPERTY_LICENSE_ISSUER = "net.nicholaswilliams.java.licensing.issuer";
    public static final String PROPERTY_LICENSE_SUBJECT = "net.nicholaswilliams.java.licensing.subject";
    public static final String PROPERTY_LICENSE_ISSUE_DATE = "net.nicholaswilliams.java.licensing.issueDate";
    public static final String PROPERTY_LICENSE_GOOD_AFTER_DATE = "net.nicholaswilliams.java.licensing.goodAfterDate";
    public static final String PROPERTY_LICENSE_GOOD_BEFORE_DATE = "net.nicholaswilliams.java.licensing.goodBeforeDate";
    public static final String PROPERTY_LICENSE_NUM_LICENSES = "net.nicholaswilliams.java.licensing.numberOfLicenses";
    public static final String PROPERTY_LICENSE_FEATURE_PREFIX = "net.nicholaswilliams.java.licensing.features.";
    public static final String PROPERTY_LICENSE_FILE = "net.nicholaswilliams.java.licensing.licenseFile";
    public static final String PROPERTY_LICENSE_PASSWORD = "net.nicholaswilliams.java.licensing.password";
    private static final int CLI_WIDTH = 105;
    private static final String USAGE = " ConsoleLicenseGenerator -help\r\n ConsoleLicenseGenerator\r\n ConsoleLicenseGenerator -config <file>\r\n ConsoleLicenseGenerator -license <file>\r\n ConsoleLicenseGenerator -config <file> -license <file>\r\n \r\n The ConsoleLicenseGenerator expects to be passed the path to two properties files, or one of them, or neither. The \"config\" properties file contains information necessary to generate all licenses (key paths, passwords, etc.) and generally will not need to change. The \"license\" properties file contains all of the information you need to generate this particular license. See the Javadoc API documentation for information about the contents of these two files.\r\n \r\n If you do not specify the \"config\" properties file, you will be prompted to provide the values that were expected in that file. Likewise, if you do not specify the \"license\" properties file, you will be prompted to provide the values that were expected in that file.";
    private static final Option HELP = CliOptionsBuilder.get().withDescription("Display this help message").hasArg(false).create("help");
    private static final Option CONFIG = CliOptionsBuilder.get().withArgName("file").withDescription("Specify the .properties file that configures this generator").hasArg(true).isRequired(false).create("config");
    private static final Option LICENSE = CliOptionsBuilder.get().withArgName("file").withDescription("Specify the .properties file that contains the data for this license").hasArg(true).isRequired(false).create("license");
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final TextInterfaceDevice device;
    private final CommandLineParser cliParser;
    protected CommandLine cli = null;

    protected ConsoleLicenseGenerator(TextInterfaceDevice textInterfaceDevice, CommandLineParser commandLineParser) {
        this.device = textInterfaceDevice;
        this.cliParser = commandLineParser;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.device.printOutLn();
    }

    protected void processCommandLineOptions(String[] stringArray) {
        Options options = new Options();
        options.addOption(HELP);
        Options options2 = new Options();
        options2.addOption(HELP).addOption(CONFIG).addOption(LICENSE);
        try {
            this.cli = this.cliParser.parse(options, stringArray, true);
            if (this.cli.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                this.printHelp(helpFormatter, options2);
                this.device.exit(0);
            } else {
                this.cli = this.cliParser.parse(options2, stringArray);
            }
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            this.device.printErrLn(parseException.getLocalizedMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            this.printHelp(helpFormatter, options2);
            this.device.exit(1);
        }
    }

    private void printHelp(HelpFormatter helpFormatter, Options options) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.device.out(), LicensingCharsets.UTF_8);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        helpFormatter.printHelp(printWriter, 105, USAGE, null, options, 1, 3, null, false);
        printWriter.close();
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.device.err());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readPropertiesFile(String string) throws Exception {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("The file [" + string + "] does not exist.");
        }
        if (!file.canRead()) {
            throw new IOException("The file [" + string + "] is not readable.");
        }
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, LicensingCharsets.UTF_8);
            Properties properties = new Properties();
            properties.load(inputStreamReader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected String promptForString(String string) {
        String string2 = this.device.readLine(string, new Object[0]);
        this.device.printOutLn();
        return string2 != null && string2.trim().length() > 0 ? string2.trim() : null;
    }

    protected char[] promptForPassword(String string) {
        char[] cArray = this.device.readPassword(string, new Object[0]);
        this.device.printOutLn();
        return cArray != null && cArray.length > 0 ? cArray : null;
    }

    protected void initializeLicenseCreator() throws Exception {
        String string;
        Properties properties = null;
        if (this.cli.hasOption("config") && (string = this.cli.getOptionValue("config")) != null && string.trim().length() > 0) {
            properties = this.readPropertiesFile(string);
        }
        LicenseCreatorProperties.setPrivateKeyDataProvider((PrivateKeyDataProvider)this.getPrivateKeyDataProvider(properties));
        LicenseCreatorProperties.setPrivateKeyPasswordProvider((PasswordProvider)this.getPrivateKeyPasswordProvider(properties));
        LicenseCreator.getInstance();
    }

    private boolean promptToUsePrivateKeyProviderClass() {
        this.device.printOutLn("Would you like to...");
        this.device.printOutLn("    (1) Read the private key from a file?");
        this.device.printOutLn("    (2) Use a PrivateKeyDataProvider implementation from the classpath?");
        String string = this.device.readLine("Your selection (default 1)? ", new Object[0]);
        this.device.printOutLn();
        return string != null && string.trim().equals("2");
    }

    private PrivateKeyDataProvider getPrivateKeyDataProvider(Properties properties) throws FileNotFoundException {
        PrivateKeyDataProvider privateKeyDataProvider;
        if (properties == null) {
            if (!this.promptToUsePrivateKeyProviderClass()) {
                String string = this.promptForString("Please enter the name of the private key file to use: ");
                File file = null;
                while (file == null) {
                    while (string == null) {
                        string = this.promptForString("Invalid or non-existent file. Please enter the name of the private key file to use: ");
                    }
                    file = new File(string);
                    if (file.exists() && file.canRead()) continue;
                    string = null;
                    file = null;
                }
                privateKeyDataProvider = new FilePrivateKeyDataProvider(file);
            } else {
                String string = this.promptForString("Please enter the fully-qualified class name for the PrivateKeyDataProvider implementation: ");
                while (string == null) {
                    string = this.promptForString("Please enter the fully-qualified class name for the PrivateKeyDataProvider implementation: ");
                }
                privateKeyDataProvider = this.getObjectAsClass(string, PrivateKeyDataProvider.class);
            }
        } else {
            String string = properties.getProperty(PROPERTY_PRIVATE_KEY_FILE);
            if (string != null && string.trim().length() > 0) {
                File file = new File(string);
                if (!file.exists() || !file.canRead()) {
                    throw new FileNotFoundException("The private key file [" + file.getAbsolutePath() + "] does not exist or cannot be read.");
                }
                privateKeyDataProvider = new FilePrivateKeyDataProvider(file);
            } else {
                String string2 = properties.getProperty(PROPERTY_PRIVATE_KEY_PROVIDER);
                if (string2 != null && string2.trim().length() > 0) {
                    privateKeyDataProvider = this.getObjectAsClass(string2, PrivateKeyDataProvider.class);
                } else {
                    throw new RuntimeException("Neither [net.nicholaswilliams.java.licensing.privateKeyFile] nor [net.nicholaswilliams.java.licensing.privateKeyProvider] properties specified.");
                }
            }
        }
        return privateKeyDataProvider;
    }

    private boolean promptToUsePasswordProviderClass() {
        this.device.printOutLn("Would you like to...");
        this.device.printOutLn("    (1) Type the private key password in manually?");
        this.device.printOutLn("    (2) Use a PasswordProvider implementation from the classpath?");
        String string = this.device.readLine("Your selection (default 1)? ", new Object[0]);
        this.device.printOutLn();
        return string != null && string.trim().equals("2");
    }

    private PasswordProvider getPrivateKeyPasswordProvider(Properties properties) {
        PrivatePasswordProvider privatePasswordProvider;
        if (properties == null) {
            if (!this.promptToUsePasswordProviderClass()) {
                char[] cArray = this.promptForPassword("Please type the password for the private key: ");
                while (cArray == null) {
                    cArray = this.promptForPassword("Invalid password. Please type the password for the private key: ");
                }
                privatePasswordProvider = new PrivatePasswordProvider(cArray);
            } else {
                String string = this.promptForString("Please enter the fully-qualified class name for the PasswordProvider implementation: ");
                while (string == null) {
                    string = this.promptForString("Please enter the fully-qualified class name for the PasswordProvider implementation: ");
                }
                privatePasswordProvider = this.getObjectAsClass(string, PasswordProvider.class);
            }
        } else {
            String string = properties.getProperty(PROPERTY_PRIVATE_KEY_PASSWORD);
            if (string != null && string.trim().length() > 0) {
                privatePasswordProvider = new PrivatePasswordProvider(string.toCharArray());
            } else {
                String string2 = properties.getProperty(PROPERTY_PRIVATE_KEY_PASSWORD_PROVIDER);
                if (string2 != null && string2.trim().length() > 0) {
                    privatePasswordProvider = this.getObjectAsClass(string2, PasswordProvider.class);
                } else {
                    throw new RuntimeException("Neither [net.nicholaswilliams.java.licensing.privateKeyPassword] nor [net.nicholaswilliams.java.licensing.privateKeyPasswordProvider] properties specified.");
                }
            }
        }
        return privatePasswordProvider;
    }

    private <T> T getObjectAsClass(String string, Class<T> clazz) {
        try {
            Class<?> clazz2 = Class.forName(string);
            return clazz2.asSubclass(clazz).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("The class [" + string + "] could not be located.");
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("The class [" + string + "] does not implement interface [" + clazz.getCanonicalName() + "].");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate class [" + string + "].", exception);
        }
    }

    protected void generateLicense() throws Exception {
        Object object;
        Map.Entry entry2;
        Object object2;
        Properties properties = null;
        if (this.cli.hasOption("license") && (object2 = this.cli.getOptionValue("license")) != null && ((String)object2).trim().length() > 0) {
            properties = this.readPropertiesFile((String)object2);
        }
        object2 = new License.Builder();
        Object object3 = this.getLicenseProductKey(properties);
        if (object3 != null) {
            object2.withProductKey((String)object3);
        }
        if ((object3 = this.getLicenseHolder(properties)) != null) {
            object2.withHolder((String)object3);
        }
        if ((object3 = this.getLicenseIssuer(properties)) != null) {
            object2.withIssuer((String)object3);
        }
        if ((object3 = this.getLicenseSubject(properties)) != null) {
            object2.withSubject((String)object3);
        }
        object2.withIssueDate(this.getLicenseIssueDate(properties));
        object2.withGoodAfterDate(this.getLicenseGoodAfterDate(properties));
        object2.withGoodBeforeDate(this.getLicenseGoodBeforeDate(properties));
        object2.withNumberOfLicenses(this.getLicenseNumberOfLicenses(properties));
        object3 = this.getLicenseFeatures(properties);
        for (Map.Entry entry2 : object3.entrySet()) {
            object = (String)entry2.getKey();
            Long l = (Long)object3.get(object);
            if (l == null || l <= 0L) {
                object2.addFeature((String)object);
                continue;
            }
            object2.addFeature((String)object, l.longValue());
        }
        Object object4 = this.getLicensePassword(properties);
        object = object2.build();
        entry2 = object4 != null ? (Map.Entry)LicenseCreator.getInstance().signAndSerializeLicense(object, (char[])object4) : (Map.Entry)LicenseCreator.getInstance().signAndSerializeLicense(object);
        this.returnLicenseData((byte[])entry2, properties);
    }

    private String getLicenseProductKey(Properties properties) {
        if (properties == null) {
            return this.promptForString("Please enter a product key for this license (you can leave this blank): ");
        }
        return properties.getProperty(PROPERTY_LICENSE_PRODUCT_KEY);
    }

    private String getLicenseHolder(Properties properties) {
        if (properties == null) {
            return this.promptForString("Please enter a holder for this license (you can leave this blank): ");
        }
        return properties.getProperty(PROPERTY_LICENSE_HOLDER);
    }

    private String getLicenseIssuer(Properties properties) {
        if (properties == null) {
            return this.promptForString("Please enter an issuer for this license (you can leave this blank): ");
        }
        return properties.getProperty(PROPERTY_LICENSE_ISSUER);
    }

    private String getLicenseSubject(Properties properties) {
        if (properties == null) {
            return this.promptForString("Please enter a subject for this license (you can leave this blank): ");
        }
        return properties.getProperty(PROPERTY_LICENSE_SUBJECT);
    }

    private long parseDate(String string) {
        if (string == null || string.trim().length() == 0) {
            return 0L;
        }
        try {
            return this.simpleDateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            return 0L;
        }
    }

    private long getLicenseIssueDate(Properties properties) {
        if (properties == null) {
            return this.parseDate(this.promptForString("Please enter an issue date for this license (YYYY-MM-DD hh:mm:ss or blank): "));
        }
        return this.parseDate(properties.getProperty(PROPERTY_LICENSE_ISSUE_DATE));
    }

    private long getLicenseGoodAfterDate(Properties properties) {
        if (properties == null) {
            return this.parseDate(this.promptForString("Please enter an activation/good-after date for this license (YYYY-MM-DD hh:mm:ss or blank): "));
        }
        return this.parseDate(properties.getProperty(PROPERTY_LICENSE_GOOD_AFTER_DATE));
    }

    private long getLicenseGoodBeforeDate(Properties properties) {
        if (properties == null) {
            return this.parseDate(this.promptForString("Please enter an expiration date for this license (YYYY-MM-DD hh:mm:ss or blank): "));
        }
        return this.parseDate(properties.getProperty(PROPERTY_LICENSE_GOOD_BEFORE_DATE));
    }

    private int parseInt(String string) {
        if (string == null || string.trim().length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int getLicenseNumberOfLicenses(Properties properties) {
        if (properties == null) {
            return this.parseInt(this.promptForString("Please enter a number of seats/licenses for this license (you can leave this blank): "));
        }
        return this.parseInt(properties.getProperty(PROPERTY_LICENSE_NUM_LICENSES));
    }

    public Map<String, Long> getLicenseFeatures(Properties properties) {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (properties == null) {
            String string = this.promptForString("Optionally enter the name/key of a feature you want to add to this license (you can leave this blank): ");
            while (string != null) {
                long l = this.parseDate(this.promptForString("Optionally enter an expiration date for feature [" + string + "] (YYYY-MM-DD hh:mm:ss or blank): "));
                hashMap.put(string, l);
                string = this.promptForString("Enter another feature to add to this license (you can leave this blank): ");
            }
        } else {
            for (String string : properties.stringPropertyNames()) {
                if (!string.startsWith(PROPERTY_LICENSE_FEATURE_PREFIX)) continue;
                String string2 = string.replace(PROPERTY_LICENSE_FEATURE_PREFIX, "");
                long l = this.parseDate(properties.getProperty(string));
                hashMap.put(string2, l);
            }
        }
        return hashMap;
    }

    private char[] getLicensePassword(Properties properties) {
        if (properties == null) {
            char[] cArray = this.device.promptForValidPassword(0, 32, "the license with (if left blank, will use the private key password provider)");
            this.device.printOutLn();
            return cArray == null || cArray.length == 0 ? null : cArray;
        }
        String string = properties.getProperty(PROPERTY_LICENSE_PASSWORD);
        return string == null || string.trim().length() == 0 ? null : string.toCharArray();
    }

    private boolean promptToWriteLicenseToFile() {
        this.device.printOutLn("Would you like to...");
        this.device.printOutLn("    (1) Output the Base64-encoded license data to the screen?");
        this.device.printOutLn("    (2) Write the raw, binary license data to a file?");
        String string = this.device.readLine("Your selection (default 1)? ", new Object[0]);
        this.device.printOutLn();
        return string != null && string.trim().equals("2");
    }

    private void returnLicenseData(byte[] byArray, Properties properties) throws Exception {
        if (properties == null) {
            if (this.promptToWriteLicenseToFile()) {
                String string = this.promptForString("Please enter the name of the file to save the license to: ");
                while (string == null) {
                    string = this.promptForString("Invalid file name. Please enter the name of the file to save the license to: ");
                }
                File file = new File(string);
                FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
            } else {
                this.device.printOutLn("License Data:");
                this.device.printOutLn(new String(Base64.encodeBase64((byte[])byArray), LicensingCharsets.UTF_8));
            }
        } else {
            String string = properties.getProperty(PROPERTY_LICENSE_FILE);
            if (string != null && string.trim().length() > 0) {
                File file = new File(string);
                FileUtils.writeByteArrayToFile((File)file, (byte[])byArray);
            } else {
                this.device.printOut(new String(Base64.encodeBase64((byte[])byArray), LicensingCharsets.UTF_8));
            }
        }
    }

    public void run(String[] stringArray) {
        this.processCommandLineOptions(stringArray);
        try {
            this.initializeLicenseCreator();
            this.generateLicense();
        }
        catch (KeyNotFoundException keyNotFoundException) {
            this.device.printErrLn(keyNotFoundException.getLocalizedMessage() + " Correct the error and try again.");
            this.device.exit(51);
            return;
        }
        catch (ObjectSerializationException objectSerializationException) {
            this.device.printErrLn(objectSerializationException.getLocalizedMessage() + " Correct the error and try again.");
            this.device.exit(52);
            return;
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.device.printErrLn(algorithmNotSupportedException.getLocalizedMessage() + " Contact your system administrator for assistance.");
            this.device.exit(41);
            return;
        }
        catch (InappropriateKeyException inappropriateKeyException) {
            this.device.printErrLn(inappropriateKeyException.getLocalizedMessage() + " Contact your system administrator for assistance.");
            this.device.exit(42);
            return;
        }
        catch (InappropriateKeySpecificationException inappropriateKeySpecificationException) {
            this.device.printErrLn(inappropriateKeySpecificationException.getLocalizedMessage() + " Contact your system administrator for assistance.");
            this.device.exit(43);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.device.printErrLn("The system was interrupted while waiting for events to complete.");
            this.device.exit(44);
            return;
        }
        catch (IOException iOException) {
            this.device.printErrLn("An error occurred writing or reading files from the system. Analyze the error below to determine what went wrong and fix it!");
            this.device.printErrLn(iOException.toString());
            iOException.printStackTrace();
            this.device.exit(21);
            return;
        }
        catch (Throwable throwable) {
            this.device.printErrLn(throwable.toString());
            throwable.printStackTrace();
            this.device.exit(-1);
            return;
        }
        this.device.exit(0);
    }

    public static void main(String ... stringArray) {
        TextInterfaceDevice textInterfaceDevice = TextInterfaceDevice.CONSOLE;
        ConsoleUtilities.configureInterfaceDevice(textInterfaceDevice);
        new ConsoleLicenseGenerator(textInterfaceDevice, (CommandLineParser)new GnuParser()).run(stringArray);
    }

    private static final class PrivatePasswordProvider
    implements PasswordProvider {
        private final char[] password;

        PrivatePasswordProvider(char[] cArray) {
            this.password = cArray;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

