/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.licensor.interfaces.cli;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import net.nicholaswilliams.java.licensing.LicensingCharsets;
import net.nicholaswilliams.java.licensing.encryption.RSAKeyPairGenerator;
import net.nicholaswilliams.java.licensing.encryption.RSAKeyPairGeneratorInterface;
import net.nicholaswilliams.java.licensing.exception.AlgorithmNotSupportedException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeyException;
import net.nicholaswilliams.java.licensing.exception.InappropriateKeySpecificationException;
import net.nicholaswilliams.java.licensing.exception.RSA2048NotSupportedException;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.ConsoleUtilities;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.Periods;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi.CliOptionsBuilder;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi.TextInterfaceDevice;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ConsoleRSAKeyPairGenerator {
    private static final int CLI_WIDTH = 105;
    private static final String USAGE = " ConsoleRSAKeyPairGenerator -help\r\n ConsoleRSAKeyPairGenerator -interactive\r\n ConsoleRSAKeyPairGenerator -password <password> -private <file|class name> -public <file|class name> [-privatePassword <password>] [-classes -passwordClass <class name> -privatePasswordClass <class name> [-privatePackage <package>] [-publicPackage <package>] [-passwordPackage <package>] [-privatePasswordPackage <package>]]";
    private static final Option HELP = CliOptionsBuilder.get().withDescription("Display this help message").hasArg(false).create("help");
    private static final Option INTERACTIVE = CliOptionsBuilder.get().withDescription("Specify to use interactive mode and ignore command-line options").isRequired(false).hasArg(false).create("interactive");
    private static final Option GENERATE_CLASSES = CliOptionsBuilder.get().withDescription("Specify to generate compilable Java classes instead of key files").isRequired(false).hasArg(false).create("classes");
    private static final Option PRIVATE_FILE = CliOptionsBuilder.get().withArgName("file|class name").withDescription("The name of the private key file or class to generate (required unless in interactive mode)").isRequired(true).hasArg(true).create("private");
    private static final Option PRIVATE_PACKAGE = CliOptionsBuilder.get().withArgName("package").withDescription("The name of the package to use for the private key class (optional, ignored unless generating classes)").isRequired(false).hasArg(true).create("privatePackage");
    private static final Option PUBLIC_FILE = CliOptionsBuilder.get().withArgName("file|class name").withDescription("The name of the public key file or class to generate (required unless in interactive mode)").isRequired(true).hasArg(true).create("public");
    private static final Option PUBLIC_PACKAGE = CliOptionsBuilder.get().withArgName("package").withDescription("The name of the package to use for the public key class (optional, ignored unless generating classes)").isRequired(false).hasArg(true).create("publicPackage");
    private static final Option PASSWORD = CliOptionsBuilder.get().withArgName("password").withDescription("The password to use to encrypt the public and private keys (required unless in interactive mode)").isRequired(true).hasArg(true).create("password");
    private static final Option PASSWORD_CLASS = CliOptionsBuilder.get().withArgName("class name").withDescription("The name of the password storage class to generate (optional, ignored unless generating classes)").isRequired(false).hasArg(true).create("passwordClass");
    private static final Option PASSWORD_PACKAGE = CliOptionsBuilder.get().withArgName("package").withDescription("The name of the package to use for the password storage class (optional, ignored unless generating classes)").isRequired(false).hasArg(true).create("passwordPackage");
    private static final Option PRIVATE_PASSWORD = CliOptionsBuilder.get().withArgName("password").withDescription("A different password to use to encrypt the private key (optional)").isRequired(false).hasArg(true).create("privatePassword");
    private static final Option PRIVATE_PASSWORD_CLASS = CliOptionsBuilder.get().withArgName("class name").withDescription("The name of the private key password storage class to generate (optional, ignored unless generating classes)").isRequired(false).hasArg(true).create("privatePasswordClass");
    private static final Option PRIVATE_PASSWORD_PACKAGE = CliOptionsBuilder.get().withArgName("package").withDescription("The name of the package to use for the private key password storage class (optional, ignored unless generating classes)").isRequired(false).hasArg(true).create("privatePasswordPackage");
    private final RSAKeyPairGeneratorInterface generator;
    private final TextInterfaceDevice device;
    private final CommandLineParser cliParser;
    protected CommandLine cli = null;
    protected boolean interactive = false;

    protected ConsoleRSAKeyPairGenerator(RSAKeyPairGeneratorInterface rSAKeyPairGeneratorInterface, TextInterfaceDevice textInterfaceDevice, CommandLineParser commandLineParser) {
        this.generator = rSAKeyPairGeneratorInterface;
        this.device = textInterfaceDevice;
        this.cliParser = commandLineParser;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.device.printOutLn();
    }

    protected void processCommandLineOptions(String[] stringArray) {
        Options options = new Options();
        options.addOption(HELP).addOption(INTERACTIVE).addOption(GENERATE_CLASSES);
        Options options2 = new Options();
        options2.addOption(HELP).addOption(INTERACTIVE).addOption(GENERATE_CLASSES).addOption(PRIVATE_FILE).addOption(PRIVATE_PACKAGE).addOption(PUBLIC_FILE).addOption(PUBLIC_PACKAGE).addOption(PASSWORD).addOption(PASSWORD_CLASS).addOption(PASSWORD_PACKAGE).addOption(PRIVATE_PASSWORD).addOption(PRIVATE_PASSWORD_CLASS).addOption(PRIVATE_PASSWORD_PACKAGE);
        try {
            this.cli = this.cliParser.parse(options, stringArray, true);
            if (this.cli.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                this.printHelp(helpFormatter, options2);
                this.device.exit(0);
            } else if (this.cli.hasOption("interactive")) {
                this.cli = null;
                this.interactive = true;
            } else {
                this.cli = this.cliParser.parse(options2, stringArray);
            }
        }
        catch (ParseException parseException) {
            this.device.printErrLn(parseException.getLocalizedMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            this.printHelp(helpFormatter, options2);
            this.device.exit(1);
        }
    }

    private void printHelp(HelpFormatter helpFormatter, Options options) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.device.out(), LicensingCharsets.UTF_8);
        PrintWriter printWriter = new PrintWriter(outputStreamWriter);
        helpFormatter.printHelp(printWriter, 105, USAGE, null, options, 1, 3, null, false);
        printWriter.close();
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.device.err());
        }
    }

    protected boolean promptToGenerateClasses() {
        this.device.printOutLn("Would you like to...");
        this.device.printOutLn("    (1) Save the public and private keys to .key files?");
        this.device.printOutLn("    (2) Generate compilable Java code with embedded keys?");
        String string = this.device.readLine("Your selection (default 1)? ", new Object[0]);
        this.device.printOutLn();
        return string != null && string.trim().equals("2");
    }

    protected boolean promptToUseDifferentPasswords() {
        this.device.printOutLn("Would you like to...");
        this.device.printOutLn("    (1) Use the same password to encrypt both keys?");
        this.device.printOutLn("    (2) Use a different password for each key?");
        String string = this.device.readLine("Your selection (default 1)? ", new Object[0]);
        this.device.printOutLn();
        return string != null && string.trim().equals("2");
    }

    protected String promptForString(String string) {
        String string2 = this.device.readLine(string, new Object[0]);
        this.device.printOutLn();
        return string2 != null && string2.trim().length() > 0 ? string2.trim() : null;
    }

    protected boolean checkAndPromptToOverwriteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            String string2;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            if (!file.canRead() || !file.canWrite()) {
                this.device.printErrLn("The file " + string2 + " already exists and cannot be overwritten.");
                return false;
            }
            String string3 = this.device.readLine("The file \"%s\" already exists. Overwrite it (YES/no)? ", string2).trim();
            return string3.length() == 0 || string3.equalsIgnoreCase("y") || string3.equalsIgnoreCase("yes");
        }
        return true;
    }

    protected void doInteractive() throws Exception {
        KeyPairGeneratorInternal keyPairGeneratorInternal = new KeyPairGeneratorInternal();
        keyPairGeneratorInternal.generateClasses = this.promptToGenerateClasses();
        keyPairGeneratorInternal.useDifferentPasswords = this.promptToUseDifferentPasswords();
        keyPairGeneratorInternal.password = this.device.promptForValidPassword(6, 32, keyPairGeneratorInternal.useDifferentPasswords ? "the public key" : "both keys");
        this.device.printOutLn("Passwords match.");
        if (keyPairGeneratorInternal.useDifferentPasswords) {
            this.device.printOutLn();
        }
        if (keyPairGeneratorInternal.useDifferentPasswords) {
            keyPairGeneratorInternal.privatePassword = this.device.promptForValidPassword(6, 32, "the private key");
            this.device.printOutLn("Passwords match.");
        } else {
            keyPairGeneratorInternal.privatePassword = null;
        }
        this.device.printOutLn();
        while (keyPairGeneratorInternal.publicOutputStore == null) {
            keyPairGeneratorInternal.publicOutputStore = this.promptForString(keyPairGeneratorInternal.generateClasses ? "Please enter the name of a Java class to embed the public key in: " : "Please enter the name of a file to store the public key in: ");
        }
        String string = keyPairGeneratorInternal.publicClassPackage = keyPairGeneratorInternal.generateClasses ? this.promptForString("Enter an optional package name for the public key class: ") : null;
        while (keyPairGeneratorInternal.privateOutputStore == null) {
            keyPairGeneratorInternal.privateOutputStore = this.promptForString(keyPairGeneratorInternal.generateClasses ? "Please enter the name of a Java class to embed the private key in: " : "Please enter the name of a file to store the private key in: ");
        }
        String string2 = keyPairGeneratorInternal.privateClassPackage = keyPairGeneratorInternal.generateClasses ? this.promptForString("Enter an optional package name for the private key class: ") : null;
        if (keyPairGeneratorInternal.generateClasses) {
            String string3 = keyPairGeneratorInternal.useDifferentPasswords ? "public key" : "key";
            keyPairGeneratorInternal.passwordClass = this.promptForString("If you wish to embed the " + string3 + " password in a Java " + "class, enter the class name now: ");
            if (keyPairGeneratorInternal.passwordClass != null) {
                keyPairGeneratorInternal.passwordPackage = this.promptForString("You can optionally enter a package name for the " + string3 + " storage class: ");
            }
            if (keyPairGeneratorInternal.useDifferentPasswords) {
                keyPairGeneratorInternal.privatePasswordClass = this.promptForString("If you wish to embed the private key password in a Java class, enter the class name now: ");
                if (keyPairGeneratorInternal.privatePasswordClass != null) {
                    keyPairGeneratorInternal.privatePasswordPackage = this.promptForString("You can optionally enter a package name for the private key storage class: ");
                }
            }
        }
        keyPairGeneratorInternal.doGenerateAndSaveKeyPair();
    }

    protected void doCommandLine() throws Exception {
        KeyPairGeneratorInternal keyPairGeneratorInternal = new KeyPairGeneratorInternal();
        keyPairGeneratorInternal.generateClasses = this.cli.hasOption("classes");
        keyPairGeneratorInternal.useDifferentPasswords = this.cli.hasOption("privatePassword");
        keyPairGeneratorInternal.password = this.cli.getOptionValue("password").toCharArray();
        keyPairGeneratorInternal.privatePassword = keyPairGeneratorInternal.useDifferentPasswords ? this.cli.getOptionValue("privatePassword").toCharArray() : null;
        keyPairGeneratorInternal.publicOutputStore = this.cli.getOptionValue("public");
        keyPairGeneratorInternal.publicClassPackage = this.cli.getOptionValue("publicPackage");
        keyPairGeneratorInternal.privateOutputStore = this.cli.getOptionValue("private");
        keyPairGeneratorInternal.privateClassPackage = this.cli.getOptionValue("privatePackage");
        if (keyPairGeneratorInternal.generateClasses) {
            keyPairGeneratorInternal.passwordClass = this.cli.getOptionValue("passwordClass");
            keyPairGeneratorInternal.passwordPackage = this.cli.getOptionValue("passwordPackage");
            if (keyPairGeneratorInternal.passwordPackage != null && keyPairGeneratorInternal.passwordPackage.trim().length() == 0) {
                keyPairGeneratorInternal.passwordPackage = null;
            }
            if (keyPairGeneratorInternal.useDifferentPasswords) {
                keyPairGeneratorInternal.privatePasswordClass = this.cli.getOptionValue("privatePasswordClass");
                keyPairGeneratorInternal.privatePasswordPackage = this.cli.getOptionValue("privatePasswordPackage");
                if (keyPairGeneratorInternal.privatePasswordPackage != null && keyPairGeneratorInternal.privatePasswordPackage.trim().length() == 0) {
                    keyPairGeneratorInternal.privatePasswordPackage = null;
                }
            }
        }
        keyPairGeneratorInternal.doGenerateAndSaveKeyPair();
    }

    public void run(String[] stringArray) {
        this.processCommandLineOptions(stringArray);
        try {
            if (this.interactive) {
                this.device.printOutLn("Using interactive mode...");
                this.device.printOutLn();
                this.doInteractive();
            } else {
                this.doCommandLine();
            }
        }
        catch (RSA2048NotSupportedException rSA2048NotSupportedException) {
            this.device.printErrLn(rSA2048NotSupportedException.getLocalizedMessage());
            if (rSA2048NotSupportedException.getCause() != null && rSA2048NotSupportedException.getCause() instanceof NoSuchAlgorithmException) {
                this.device.exit(51);
            } else {
                this.device.exit(52);
            }
            return;
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.device.printErrLn(algorithmNotSupportedException.getLocalizedMessage() + " Contact your system administrator for assistance.");
            this.device.exit(41);
            return;
        }
        catch (InappropriateKeyException inappropriateKeyException) {
            this.device.printErrLn(inappropriateKeyException.getLocalizedMessage() + " Contact your system administrator for assistance.");
            this.device.exit(42);
            return;
        }
        catch (InappropriateKeySpecificationException inappropriateKeySpecificationException) {
            this.device.printErrLn(inappropriateKeySpecificationException.getLocalizedMessage() + " Contact your system administrator for assistance.");
            this.device.exit(43);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.device.printErrLn("The system was interrupted while waiting for events to complete.");
            this.device.exit(44);
            return;
        }
        catch (IOException iOException) {
            this.device.printErrLn("An error occurred writing the key files to the file system. Analyze the error below to determine what went wrong and fix it!");
            this.device.printErrLn(iOException.toString());
            iOException.printStackTrace();
            this.device.exit(21);
            return;
        }
        catch (Throwable throwable) {
            this.device.printErrLn(throwable.toString());
            throwable.printStackTrace();
            this.device.exit(-1);
            return;
        }
        this.device.exit(0);
    }

    public static void main(String ... stringArray) {
        TextInterfaceDevice textInterfaceDevice = TextInterfaceDevice.CONSOLE;
        ConsoleUtilities.configureInterfaceDevice(textInterfaceDevice);
        new ConsoleRSAKeyPairGenerator((RSAKeyPairGeneratorInterface)new RSAKeyPairGenerator(), textInterfaceDevice, (CommandLineParser)new GnuParser()).run(stringArray);
    }

    protected class KeyPairGeneratorInternal {
        boolean generateClasses;
        boolean useDifferentPasswords;
        char[] password;
        char[] privatePassword;
        String privateOutputStore;
        String privateClassPackage;
        String publicOutputStore;
        String publicClassPackage;
        String passwordClass;
        String passwordPackage;
        String privatePasswordClass;
        String privatePasswordPackage;

        protected KeyPairGeneratorInternal() {
        }

        public void doGenerateAndSaveKeyPair() throws InterruptedException, IOException {
            ConsoleRSAKeyPairGenerator.this.device.printOut("Generating RSA key pair, 2048-bit long modulus");
            Periods periods = new Periods(25L, ConsoleRSAKeyPairGenerator.this.device.out());
            new Thread(periods).start();
            Thread.sleep(50L);
            KeyPair keyPair = ConsoleRSAKeyPairGenerator.this.generator.generateKeyPair();
            periods.stop();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("+++");
            ConsoleRSAKeyPairGenerator.this.device.printOutLn();
            ConsoleRSAKeyPairGenerator.this.device.printOut("Key pair generated. Encrypting keys with 128-bit AES security");
            periods = new Periods(25L, ConsoleRSAKeyPairGenerator.this.device.out());
            new Thread(periods).start();
            Thread.sleep(50L);
            if (this.generateClasses) {
                this.doGenerateClasses(keyPair, periods);
            } else {
                this.doGenerateFiles(keyPair, periods);
            }
            Arrays.fill(this.password, '\u0000');
            if (this.useDifferentPasswords) {
                Arrays.fill(this.privatePassword, '\u0000');
            }
        }

        public void doGenerateClasses(KeyPair keyPair, Periods periods) {
            RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor = new RSAKeyPairGeneratorInterface.GeneratedClassDescriptor().setClassName(this.privateOutputStore).setPackageName(this.privateClassPackage);
            RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor2 = new RSAKeyPairGeneratorInterface.GeneratedClassDescriptor().setClassName(this.publicOutputStore).setPackageName(this.publicClassPackage);
            if (this.useDifferentPasswords) {
                ConsoleRSAKeyPairGenerator.this.generator.saveKeyPairToProviders(keyPair, generatedClassDescriptor, generatedClassDescriptor2, this.privatePassword, this.password);
            } else {
                ConsoleRSAKeyPairGenerator.this.generator.saveKeyPairToProviders(keyPair, generatedClassDescriptor, generatedClassDescriptor2, this.password);
            }
            RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor3 = new RSAKeyPairGeneratorInterface.GeneratedClassDescriptor().setClassName(this.passwordClass).setPackageName(this.passwordPackage);
            RSAKeyPairGeneratorInterface.GeneratedClassDescriptor generatedClassDescriptor4 = new RSAKeyPairGeneratorInterface.GeneratedClassDescriptor().setClassName(this.privatePasswordClass).setPackageName(this.privatePasswordPackage);
            if (this.passwordClass != null) {
                ConsoleRSAKeyPairGenerator.this.generator.savePasswordToProvider(this.password, generatedClassDescriptor3);
            }
            if (this.useDifferentPasswords && this.privatePasswordClass != null) {
                ConsoleRSAKeyPairGenerator.this.generator.savePasswordToProvider(this.privatePassword, generatedClassDescriptor4);
            }
            periods.stop();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("+++");
            ConsoleRSAKeyPairGenerator.this.device.printOutLn();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("Private key provider:");
            ConsoleRSAKeyPairGenerator.this.device.printOutLn();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn(generatedClassDescriptor.getJavaFileContents());
            ConsoleRSAKeyPairGenerator.this.device.printOutLn();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("Public key provider:");
            ConsoleRSAKeyPairGenerator.this.device.printOutLn();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn(generatedClassDescriptor2.getJavaFileContents());
            if (this.passwordClass != null) {
                ConsoleRSAKeyPairGenerator.this.device.printOutLn();
                ConsoleRSAKeyPairGenerator.this.device.printOutLn(this.useDifferentPasswords ? "Public key password provider:" : "Key password provider:");
                ConsoleRSAKeyPairGenerator.this.device.printOutLn();
                ConsoleRSAKeyPairGenerator.this.device.printOutLn(generatedClassDescriptor3.getJavaFileContents());
            }
            if (this.useDifferentPasswords && this.privatePasswordClass != null) {
                ConsoleRSAKeyPairGenerator.this.device.printOutLn();
                ConsoleRSAKeyPairGenerator.this.device.printOutLn("Private key password provider:");
                ConsoleRSAKeyPairGenerator.this.device.printOutLn();
                ConsoleRSAKeyPairGenerator.this.device.printOutLn(generatedClassDescriptor4.getJavaFileContents());
            }
        }

        public void doGenerateFiles(KeyPair keyPair, Periods periods) throws IOException {
            if (!(!ConsoleRSAKeyPairGenerator.this.interactive || ConsoleRSAKeyPairGenerator.this.checkAndPromptToOverwriteFile(this.privateOutputStore) && ConsoleRSAKeyPairGenerator.this.checkAndPromptToOverwriteFile(this.publicOutputStore))) {
                ConsoleRSAKeyPairGenerator.this.device.exit(81);
                return;
            }
            if (this.useDifferentPasswords) {
                ConsoleRSAKeyPairGenerator.this.generator.saveKeyPairToFiles(keyPair, this.privateOutputStore, this.publicOutputStore, this.privatePassword, this.password);
            } else {
                ConsoleRSAKeyPairGenerator.this.generator.saveKeyPairToFiles(keyPair, this.privateOutputStore, this.publicOutputStore, this.password);
            }
            periods.stop();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("+++");
            ConsoleRSAKeyPairGenerator.this.device.printOutLn();
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("Private key written to " + this.privateOutputStore);
            ConsoleRSAKeyPairGenerator.this.device.printOutLn("Public key written to " + this.publicOutputStore);
        }
    }
}

