/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi;

import java.io.Console;
import java.io.IOError;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.IllegalFormatException;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi.AbstractTextInterfaceDevice;
import net.nicholaswilliams.java.licensing.licensor.interfaces.cli.spi.TextInterfaceDevice;

public class ConsoleInterfaceDevice
extends AbstractTextInterfaceDevice {
    private final Console console = System.console();
    private final Runtime runtime = Runtime.getRuntime();

    public ConsoleInterfaceDevice() {
        super(System.in, System.out, System.err);
    }

    @Override
    public void exit(int n) {
        this.runtime.exit(n);
    }

    @Override
    public void registerShutdownHook(Thread thread) throws IllegalArgumentException, IllegalStateException, SecurityException {
        this.runtime.addShutdownHook(thread);
    }

    @Override
    public boolean unregisterShutdownHook(Thread thread) throws IllegalStateException, SecurityException {
        return this.runtime.removeShutdownHook(thread);
    }

    @Override
    public TextInterfaceDevice format(String string, Object ... objectArray) throws IllegalFormatException {
        this.console.format(string, objectArray);
        return this;
    }

    @Override
    public TextInterfaceDevice printf(String string, Object ... objectArray) throws IllegalFormatException, IOError {
        this.console.printf(string, objectArray);
        return this;
    }

    @Override
    public void flush() {
        this.console.flush();
    }

    @Override
    public String readLine() throws IOError {
        return this.console.readLine();
    }

    @Override
    public String readLine(String string, Object ... objectArray) throws IllegalFormatException, IOError {
        return this.console.readLine(string, objectArray);
    }

    @Override
    public char[] readPassword() throws IOError {
        return this.console.readPassword();
    }

    @Override
    public char[] readPassword(String string, Object ... objectArray) throws IllegalFormatException, IOError {
        return this.console.readPassword(string, objectArray);
    }

    @Override
    public Reader getReader() {
        return this.console.reader();
    }

    @Override
    public PrintWriter getWriter() {
        return this.console.writer();
    }

    public Console getConsole() {
        return this.console;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }
}

