/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.IntSupplier;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractLogbackAccessEvent
extends AccessEvent {
    private boolean useServerPortInsteadOfLocalPort;
    private IntSupplier localPort = (IntSupplier & Serializable)() -> {
        int value = this.takeLocalPort();
        this.localPort = (IntSupplier & Serializable)() -> value;
        return value;
    };

    public AbstractLogbackAccessEvent(HttpServletRequest request, HttpServletResponse response, ServerAdapter adapter) {
        super(request, response, adapter);
    }

    public int getLocalPort() {
        return this.localPort.getAsInt();
    }

    private int takeLocalPort() {
        return Optional.of(this).filter(AbstractLogbackAccessEvent::isUseServerPortInsteadOfLocalPort).map(AccessEvent::getRequest).map(ServletRequest::getServerPort).orElseGet(() -> super.getLocalPort());
    }

    public boolean isUseServerPortInsteadOfLocalPort() {
        return this.useServerPortInsteadOfLocalPort;
    }

    public void setUseServerPortInsteadOfLocalPort(boolean useServerPortInsteadOfLocalPort) {
        this.useServerPortInsteadOfLocalPort = useServerPortInsteadOfLocalPort;
    }
}

