/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import net.rakugakibox.spring.boot.logback.access.LogbackAccessConfigurer;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.jetty.JettyLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.tomcat.TomcatLogbackAccessInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(name={"logback.access.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={LogbackAccessProperties.class})
public class LogbackAccessAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LogbackAccessAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public LogbackAccessConfigurer logbackAccessConfigurer(LogbackAccessProperties logbackAccessProperties) {
        LogbackAccessConfigurer configurer = new LogbackAccessConfigurer(logbackAccessProperties);
        log.debug("Created a LogbackAccessConfigurer: [{}]", (Object)configurer);
        return configurer;
    }

    @Configuration
    @ConditionalOnBean(value={JettyEmbeddedServletContainerFactory.class})
    public static class Jetty {
        @Bean
        @ConditionalOnMissingBean
        public JettyLogbackAccessInstaller jettyLogbackAccessInstaller(LogbackAccessProperties logbackAccessProperties, LogbackAccessConfigurer logbackAccessConfigurer) {
            JettyLogbackAccessInstaller installer = new JettyLogbackAccessInstaller(logbackAccessProperties, logbackAccessConfigurer);
            log.debug("Created a JettyLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }
    }

    @Configuration
    @ConditionalOnBean(value={TomcatEmbeddedServletContainerFactory.class})
    public static class Tomcat {
        @Bean
        @ConditionalOnMissingBean
        public TomcatLogbackAccessInstaller tomcatLogbackAccessInstaller(LogbackAccessProperties logbackAccessProperties, LogbackAccessConfigurer logbackAccessConfigurer) {
            TomcatLogbackAccessInstaller installer = new TomcatLogbackAccessInstaller(logbackAccessProperties, logbackAccessConfigurer);
            log.debug("Created a TomcatLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }
    }
}

