/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessConfigurationException;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public class LogbackAccessConfigurer {
    private static final Logger log = LoggerFactory.getLogger(LogbackAccessConfigurer.class);
    public static final List<String> DEFAULT_CONFIGS = Collections.unmodifiableList(Arrays.asList("classpath:logback-access-test.xml", "classpath:logback-access.xml"));
    public static final String FALLBACK_CONFIG = "classpath:" + ClassUtils.addResourcePathToPackagePath(LogbackAccessConfigurer.class, (String)"logback-access.xml");
    private final LogbackAccessProperties properties;

    public void configure(Context context) throws LogbackAccessConfigurationException {
        if (this.properties.getConfig().isPresent()) {
            this.configure(context, this.properties.getConfig().get());
            return;
        }
        for (String config : DEFAULT_CONFIGS) {
            if (!this.configureIfPresent(context, config)) continue;
            return;
        }
        this.configure(context, FALLBACK_CONFIG);
    }

    private void configure(Context context, String config) throws LogbackAccessConfigurationException {
        try {
            this.configureWithCauseThrowing(context, config);
        }
        catch (Exception exc) {
            throw new LogbackAccessConfigurationException(context, config, exc);
        }
    }

    private boolean configureIfPresent(Context context, String config) throws LogbackAccessConfigurationException {
        try {
            this.configureWithCauseThrowing(context, config);
            return true;
        }
        catch (FileNotFoundException exc) {
            return false;
        }
        catch (Exception exc) {
            throw new LogbackAccessConfigurationException(context, config, exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureWithCauseThrowing(Context context, String config) throws IOException, JoranException {
        URL url = ResourceUtils.getURL((String)config);
        InputStream stream = url.openStream();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext(context);
            configurator.doConfigure(stream);
            log.info("Configured Logback-access: context=[{}], config=[{}]", (Object)context, (Object)config);
        }
        finally {
            if (Collections.singletonList(stream).get(0) != null) {
                stream.close();
            }
        }
    }

    @ConstructorProperties(value={"properties"})
    public LogbackAccessConfigurer(LogbackAccessProperties properties) {
        this.properties = properties;
    }
}

