/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.jetty;

import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessConfigurer;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.jetty.LogbackAccessJettyRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;

public class JettyLogbackAccessInstaller
extends AbstractLogbackAccessInstaller<JettyEmbeddedServletContainerFactory> {
    private static final Logger log = LoggerFactory.getLogger(JettyLogbackAccessInstaller.class);

    public JettyLogbackAccessInstaller(LogbackAccessProperties logbackAccessProperties, LogbackAccessConfigurer logbackAccessConfigurer) {
        super(JettyEmbeddedServletContainerFactory.class, logbackAccessProperties, logbackAccessConfigurer);
    }

    @Override
    public void install(JettyEmbeddedServletContainerFactory container) {
        LogbackAccessJettyRequestLog requestLog = new LogbackAccessJettyRequestLog(this.getLogbackAccessProperties(), this.getLogbackAccessConfigurer());
        container.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            RequestLogHandler requestLogHandler = new RequestLogHandler();
            requestLogHandler.setHandler(server.getHandler());
            requestLogHandler.setRequestLog((RequestLog)requestLog);
            server.setHandler((Handler)requestLogHandler);
        }});
        log.debug("Installed Logback-access: container=[{}], requestLog=[{}]", (Object)container, (Object)requestLog);
    }
}

