/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.jetty;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.FilterReply;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessConfigurer;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessContext;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.jetty.JettyLogbackAccessEvent;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class LogbackAccessJettyRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private final LogbackAccessContext logbackAccessContext = new LogbackAccessContext();
    private final LogbackAccessProperties logbackAccessProperties;
    private final LogbackAccessConfigurer logbackAccessConfigurer;

    public LogbackAccessJettyRequestLog(LogbackAccessProperties logbackAccessProperties, LogbackAccessConfigurer logbackAccessConfigurer) {
        this.logbackAccessProperties = logbackAccessProperties;
        this.logbackAccessConfigurer = logbackAccessConfigurer;
    }

    protected void doStart() throws Exception {
        this.startLogbackAccessContext();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.stopLogbackAccessContext();
    }

    public void log(Request request, Response response) {
        this.emitLogbackAccessEvent(request, response);
    }

    private void startLogbackAccessContext() {
        this.logbackAccessConfigurer.configure((Context)this.logbackAccessContext);
        this.logbackAccessContext.start();
    }

    private void stopLogbackAccessContext() {
        this.logbackAccessContext.stop();
        this.logbackAccessContext.reset();
        this.logbackAccessContext.detachAndStopAllAppenders();
        this.logbackAccessContext.clearAllFilters();
    }

    private void emitLogbackAccessEvent(Request request, Response response) {
        JettyLogbackAccessEvent event = new JettyLogbackAccessEvent(request, response);
        event.setThreadName(Thread.currentThread().getName());
        event.setUseServerPortInsteadOfLocalPort(this.logbackAccessProperties.getUseServerPortInsteadOfLocalPort());
        if (this.logbackAccessContext.getFilterChainDecision((IAccessEvent)event) != FilterReply.DENY) {
            this.logbackAccessContext.callAppenders((IAccessEvent)event);
        }
    }
}

