/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.tomcat;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.FilterReply;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessConfigurer;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessContext;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.tomcat.TomcatLogbackAccessEvent;
import org.apache.catalina.AccessLog;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.catalina.valves.ValveBase;

public class LogbackAccessTomcatValve
extends ValveBase
implements AccessLog {
    private final LogbackAccessContext logbackAccessContext = new LogbackAccessContext();
    private final LogbackAccessProperties logbackAccessProperties;
    private final LogbackAccessConfigurer logbackAccessConfigurer;
    private Optional<Boolean> requestAttributesEnabled = Optional.empty();

    public LogbackAccessTomcatValve(LogbackAccessProperties logbackAccessProperties, LogbackAccessConfigurer logbackAccessConfigurer) {
        this.logbackAccessProperties = logbackAccessProperties;
        this.logbackAccessConfigurer = logbackAccessConfigurer;
        this.requestAttributesEnabled = logbackAccessProperties.getTomcat().getEnableRequestAttributes();
        this.setAsyncSupported(true);
    }

    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled.orElse(false);
    }

    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = Optional.of(requestAttributesEnabled);
    }

    private void initializeRequestAttributesEnabled() {
        if (this.requestAttributesEnabled.isPresent()) {
            return;
        }
        boolean presenceOfRemoteIpValve = Stream.of(this.getContainer().getPipeline().getValves()).anyMatch(RemoteIpValve.class::isInstance);
        this.setRequestAttributesEnabled(presenceOfRemoteIpValve);
    }

    protected void startInternal() throws LifecycleException {
        this.initializeRequestAttributesEnabled();
        this.startLogbackAccessContext();
        super.startInternal();
    }

    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.stopLogbackAccessContext();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
    }

    public void log(Request request, Response response, long time) {
        this.emitLogbackAccessEvent(request, response);
    }

    private void startLogbackAccessContext() {
        this.logbackAccessConfigurer.configure((Context)this.logbackAccessContext);
        this.logbackAccessContext.start();
    }

    private void stopLogbackAccessContext() {
        this.logbackAccessContext.stop();
        this.logbackAccessContext.reset();
        this.logbackAccessContext.detachAndStopAllAppenders();
        this.logbackAccessContext.clearAllFilters();
    }

    private void emitLogbackAccessEvent(Request request, Response response) {
        TomcatLogbackAccessEvent event = new TomcatLogbackAccessEvent(request, response);
        event.setThreadName(Thread.currentThread().getName());
        event.setUseServerPortInsteadOfLocalPort(this.logbackAccessProperties.getUseServerPortInsteadOfLocalPort());
        event.setRequestAttributesEnabled(this.getRequestAttributesEnabled());
        if (this.logbackAccessContext.getFilterChainDecision((IAccessEvent)event) != FilterReply.DENY) {
            this.logbackAccessContext.callAppenders((IAccessEvent)event);
        }
    }
}

