/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.tomcat;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.tomcat.TomcatServerAdapter;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;

public class TomcatLogbackAccessEvent
extends AbstractLogbackAccessEvent {
    private boolean requestAttributesEnabled;
    private IntSupplier localPort = (IntSupplier & Serializable)() -> {
        int value = this.takeLocalPortOrServerPort();
        this.localPort = (IntSupplier & Serializable)() -> value;
        return value;
    };
    private Supplier<String> remoteAddr = (Supplier<String> & Serializable)() -> {
        String value = this.takeRemoteAddr();
        this.remoteAddr = (Supplier<String> & Serializable)() -> value;
        return value;
    };
    private Supplier<String> remoteHost = (Supplier<String> & Serializable)() -> {
        String value = this.takeRemoteHost();
        this.remoteHost = (Supplier<String> & Serializable)() -> value;
        return value;
    };
    private Supplier<String> protocol = (Supplier<String> & Serializable)() -> {
        String value = this.takeProtocol();
        this.protocol = (Supplier<String> & Serializable)() -> value;
        return value;
    };

    public TomcatLogbackAccessEvent(Request request, Response response) {
        super((HttpServletRequest)request, (HttpServletResponse)response, (ch.qos.logback.access.spi.ServerAdapter)new ServerAdapter(request, response));
    }

    @Override
    public int getLocalPort() {
        return this.localPort.getAsInt();
    }

    private int takeLocalPortOrServerPort() {
        return Optional.of(this).filter(AbstractLogbackAccessEvent::isUseServerPortInsteadOfLocalPort).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (Integer)request.getAttribute("org.apache.catalina.AccessLog.ServerPort")).orElseGet(() -> super.getLocalPort());
    }

    public String getRemoteAddr() {
        return this.remoteAddr.get();
    }

    private String takeRemoteAddr() {
        return Optional.of(this).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("org.apache.catalina.AccessLog.RemoteAddr")).orElseGet(() -> super.getRemoteAddr());
    }

    public String getRemoteHost() {
        return this.remoteHost.get();
    }

    private String takeRemoteHost() {
        return Optional.of(this).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("org.apache.catalina.AccessLog.RemoteHost")).orElseGet(() -> super.getRemoteHost());
    }

    public String getProtocol() {
        return this.protocol.get();
    }

    private String takeProtocol() {
        return Optional.of(this).filter(TomcatLogbackAccessEvent::isRequestAttributesEnabled).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute("org.apache.catalina.AccessLog.Protocol")).orElseGet(() -> super.getProtocol());
    }

    public boolean isRequestAttributesEnabled() {
        return this.requestAttributesEnabled;
    }

    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = requestAttributesEnabled;
    }

    public static class ServerAdapter
    extends TomcatServerAdapter {
        private final Request request;
        private final Response response;

        public ServerAdapter(Request request, Response response) {
            super(request, response);
            this.request = request;
            this.response = response;
        }

        public long getContentLength() {
            return this.takeContentLength();
        }

        private long takeContentLength() {
            long length = this.response.getBytesWritten(false);
            if (length > 0L) {
                return length;
            }
            Long start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            Long end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            if (start != null && end != null) {
                return end - start;
            }
            return super.getContentLength();
        }
    }
}

