/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.Filter;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessListener;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessSecurityAttributesSaveFilter;
import net.rakugakibox.spring.boot.logback.access.jetty.JettyLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.tomcat.TomcatLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.undertow.UndertowLogbackAccessInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.context.AbstractSecurityWebApplicationInitializer;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(name={"logback.access.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={LogbackAccessProperties.class})
public class LogbackAccessAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LogbackAccessAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={AbstractSecurityWebApplicationInitializer.class})
    public static class ForSpringSecurity {
        @Bean(value={"logbackAccessSecurityAttributesSaveFilter"})
        @ConditionalOnMissingBean(name={"logbackAccessSecurityAttributesSaveFilter"})
        public FilterRegistrationBean logbackAccessSecurityAttributesSaveFilter() {
            LogbackAccessSecurityAttributesSaveFilter filter = new LogbackAccessSecurityAttributesSaveFilter();
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
            log.debug("Created a LogbackAccessSecurityAttributesSaveFilter: [{}]", (Object)filter);
            return filterRegistrationBean;
        }
    }

    @Configuration
    @ConditionalOnBean(value={UndertowEmbeddedServletContainerFactory.class})
    public static class ForUndertow {
        private final LogbackAccessProperties logbackAccessProperties;
        private final Optional<List<LogbackAccessListener>> logbackAccessListeners;

        @Bean
        @ConditionalOnMissingBean
        public UndertowLogbackAccessInstaller undertowLogbackAccessInstaller() {
            UndertowLogbackAccessInstaller installer = new UndertowLogbackAccessInstaller(this.logbackAccessProperties, this.logbackAccessListeners.orElseGet(Collections::emptyList));
            log.debug("Created a UndertowLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }

        @ConstructorProperties(value={"logbackAccessProperties", "logbackAccessListeners"})
        public ForUndertow(LogbackAccessProperties logbackAccessProperties, Optional<List<LogbackAccessListener>> logbackAccessListeners) {
            this.logbackAccessProperties = logbackAccessProperties;
            this.logbackAccessListeners = logbackAccessListeners;
        }
    }

    @Configuration
    @ConditionalOnBean(value={JettyEmbeddedServletContainerFactory.class})
    public static class ForJetty {
        private final LogbackAccessProperties logbackAccessProperties;
        private final Optional<List<LogbackAccessListener>> logbackAccessListeners;

        @Bean
        @ConditionalOnMissingBean
        public JettyLogbackAccessInstaller jettyLogbackAccessInstaller() {
            JettyLogbackAccessInstaller installer = new JettyLogbackAccessInstaller(this.logbackAccessProperties, this.logbackAccessListeners.orElseGet(Collections::emptyList));
            log.debug("Created a JettyLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }

        @ConstructorProperties(value={"logbackAccessProperties", "logbackAccessListeners"})
        public ForJetty(LogbackAccessProperties logbackAccessProperties, Optional<List<LogbackAccessListener>> logbackAccessListeners) {
            this.logbackAccessProperties = logbackAccessProperties;
            this.logbackAccessListeners = logbackAccessListeners;
        }
    }

    @Configuration
    @ConditionalOnBean(value={TomcatEmbeddedServletContainerFactory.class})
    public static class ForTomcat {
        private final LogbackAccessProperties logbackAccessProperties;
        private final Optional<List<LogbackAccessListener>> logbackAccessListeners;

        @Bean
        @ConditionalOnMissingBean
        public TomcatLogbackAccessInstaller tomcatLogbackAccessInstaller() {
            TomcatLogbackAccessInstaller installer = new TomcatLogbackAccessInstaller(this.logbackAccessProperties, this.logbackAccessListeners.orElseGet(Collections::emptyList));
            log.debug("Created a TomcatLogbackAccessInstaller: [{}]", (Object)installer);
            return installer;
        }

        @ConstructorProperties(value={"logbackAccessProperties", "logbackAccessListeners"})
        public ForTomcat(LogbackAccessProperties logbackAccessProperties, Optional<List<LogbackAccessListener>> logbackAccessListeners) {
            this.logbackAccessProperties = logbackAccessProperties;
            this.logbackAccessListeners = logbackAccessListeners;
        }
    }
}

