/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.jetty;

import java.util.List;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessListener;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.jetty.LogbackAccessJettyRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;

public class JettyLogbackAccessInstaller
extends AbstractLogbackAccessInstaller<JettyEmbeddedServletContainerFactory> {
    private static final Logger log = LoggerFactory.getLogger(JettyLogbackAccessInstaller.class);

    public JettyLogbackAccessInstaller(LogbackAccessProperties logbackAccessProperties, List<LogbackAccessListener> logbackAccessListeners) {
        super(JettyEmbeddedServletContainerFactory.class, logbackAccessProperties, logbackAccessListeners);
    }

    @Override
    protected void installLogbackAccess(JettyEmbeddedServletContainerFactory container) {
        container.addServerCustomizers(new JettyServerCustomizer[]{this::wrapJettyHandler});
        log.debug("Installed Logback-access: container=[{}]", (Object)container);
    }

    private void wrapJettyHandler(Server server) {
        LogbackAccessJettyRequestLog requestLog = new LogbackAccessJettyRequestLog(this.logbackAccessProperties, this.logbackAccessListeners);
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        requestLogHandler.setHandler(server.getHandler());
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        server.setHandler((Handler)requestLogHandler);
    }
}

