/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessEvent;

public class UndertowLogbackAccessEvent
extends AbstractLogbackAccessEvent {
    public UndertowLogbackAccessEvent(HttpServerExchange exchange) {
        super(UndertowLogbackAccessEvent.extractHttpServletRequest(exchange), UndertowLogbackAccessEvent.extractHttpServletResponse(exchange), new ServerAdapter(exchange));
    }

    private static HttpServletRequest extractHttpServletRequest(HttpServerExchange exchange) {
        ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return (HttpServletRequest)context.getServletRequest();
    }

    private static HttpServletResponse extractHttpServletResponse(HttpServerExchange exchange) {
        ServletRequestContext context = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        return (HttpServletResponse)context.getServletResponse();
    }

    private static class ServerAdapter
    implements ch.qos.logback.access.spi.ServerAdapter {
        private final HttpServerExchange exchange;

        private ServerAdapter(HttpServerExchange exchange) {
            this.exchange = exchange;
        }

        public long getRequestTimestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            long nanoTime = System.nanoTime();
            long requestStartTime = this.exchange.getRequestStartTime();
            return currentTimeMillis - TimeUnit.NANOSECONDS.toMillis(nanoTime - requestStartTime);
        }

        public int getStatusCode() {
            return this.exchange.getStatusCode();
        }

        public long getContentLength() {
            return this.exchange.getResponseBytesSent();
        }

        public Map<String, String> buildResponseHeaderMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            HeaderMap headers = this.exchange.getResponseHeaders();
            for (HeaderValues header : headers) {
                result.put(header.getHeaderName().toString(), header.getFirst());
            }
            return result;
        }
    }
}

