/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.api.DeploymentInfo;
import net.rakugakibox.spring.boot.logback.access.AbstractLogbackAccessInstaller;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.undertow.LogbackAccessUndertowHttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class UndertowLogbackAccessInstaller
extends AbstractLogbackAccessInstaller<UndertowEmbeddedServletContainerFactory> {
    private static final Logger log = LoggerFactory.getLogger(UndertowLogbackAccessInstaller.class);

    public UndertowLogbackAccessInstaller(LogbackAccessProperties logbackAccessProperties, ApplicationEventPublisher applicationEventPublisher) {
        super(UndertowEmbeddedServletContainerFactory.class, logbackAccessProperties, applicationEventPublisher);
    }

    @Override
    protected void installLogbackAccess(UndertowEmbeddedServletContainerFactory container) {
        container.addBuilderCustomizers(new UndertowBuilderCustomizer[]{this::enableRecordingRequestStartTime});
        container.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{this::addUndertowHttpHandlerWrapper});
        log.debug("Installed Logback-access: container=[{}]", (Object)container);
    }

    private void enableRecordingRequestStartTime(Undertow.Builder builder) {
        builder.setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, (Object)true);
    }

    private void addUndertowHttpHandlerWrapper(DeploymentInfo deploymentInfo) {
        deploymentInfo.addInitialHandlerChainWrapper(this::wrapUndertowHttpHandler);
    }

    private HttpHandler wrapUndertowHttpHandler(HttpHandler handler) {
        return new LogbackAccessUndertowHttpHandler(this.logbackAccessProperties, this.applicationEventPublisher, handler);
    }
}

