/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access.tomcat;

import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessContext;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessProperties;
import net.rakugakibox.spring.boot.logback.access.tomcat.TomcatLogbackAccessEvent;
import org.apache.catalina.AccessLog;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.catalina.valves.ValveBase;
import org.springframework.context.ApplicationEventPublisher;

public class LogbackAccessTomcatValve
extends ValveBase
implements AccessLog {
    private final LogbackAccessContext logbackAccessContext;
    private BooleanSupplier requestAttributesEnabled = () -> {
        boolean requestAttributesEnabled = Stream.of(this.getContainer().getPipeline().getValves()).anyMatch(RemoteIpValve.class::isInstance);
        this.requestAttributesEnabled = () -> requestAttributesEnabled;
        return requestAttributesEnabled;
    };

    public LogbackAccessTomcatValve(LogbackAccessProperties logbackAccessProperties, ApplicationEventPublisher applicationEventPublisher) {
        this.logbackAccessContext = new LogbackAccessContext(logbackAccessProperties, applicationEventPublisher);
        this.setAsyncSupported(true);
        if (logbackAccessProperties.getTomcat().getEnableRequestAttributes() != null) {
            this.setRequestAttributesEnabled(logbackAccessProperties.getTomcat().getEnableRequestAttributes());
        }
    }

    public boolean getRequestAttributesEnabled() {
        return this.requestAttributesEnabled.getAsBoolean();
    }

    public void setRequestAttributesEnabled(boolean requestAttributesEnabled) {
        this.requestAttributesEnabled = () -> requestAttributesEnabled;
    }

    protected void startInternal() throws LifecycleException {
        this.logbackAccessContext.configure();
        this.logbackAccessContext.start();
        super.startInternal();
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
    }

    public void log(Request request, Response response, long time) {
        TomcatLogbackAccessEvent event = new TomcatLogbackAccessEvent(request, response);
        event.setRequestAttributesEnabled(this.getRequestAttributesEnabled());
        this.logbackAccessContext.emit(event);
    }
}

