/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.event.InPlayListener;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.xml.sax.Attributes;

public class LogbackAccessJoranConfigurator
extends JoranConfigurator {
    private final Environment environment;

    public void addInstanceRules(RuleStore ruleStore) {
        super.addInstanceRules(ruleStore);
        ruleStore.addRule(new ElementSelector("*/springProfile"), (Action)new SpringProfileAction());
        ruleStore.addRule(new ElementSelector("*/springProfile/*"), (Action)new NOPAction());
        ruleStore.addRule(new ElementSelector("configuration/springProperty"), (Action)new SpringPropertyAction());
    }

    @ConstructorProperties(value={"environment"})
    public LogbackAccessJoranConfigurator(Environment environment) {
        this.environment = environment;
    }

    private class SpringPropertyAction
    extends Action {
        private SpringPropertyAction() {
        }

        public void begin(InterpretationContext ic, String name, Attributes attributes) throws ActionException {
            String key = attributes.getValue("name");
            ActionUtil.Scope scope = ActionUtil.stringToScope((String)attributes.getValue("scope"));
            String source = attributes.getValue("source");
            String defaultValue = attributes.getValue("defaultValue");
            String value = LogbackAccessJoranConfigurator.this.environment.getProperty(source, defaultValue);
            ActionUtil.setProperty((InterpretationContext)ic, (String)key, (String)value, (ActionUtil.Scope)scope);
        }

        public void end(InterpretationContext ic, String name) throws ActionException {
        }
    }

    private class SpringProfileAction
    extends Action
    implements InPlayListener {
        private int depth;
        private boolean accepts;
        private final List<SaxEvent> events = new ArrayList<SaxEvent>();

        private SpringProfileAction() {
        }

        public void begin(InterpretationContext ic, String name, Attributes attributes) throws ActionException {
            ++this.depth;
            if (this.depth != 1) {
                return;
            }
            String profiles = OptionHelper.substVars((String)attributes.getValue("name"), (PropertyContainer)ic, (PropertyContainer)this.context);
            String[] normalizedProfiles = StringUtils.commaDelimitedListToStringArray((String)profiles);
            this.accepts = (normalizedProfiles = StringUtils.trimArrayElements((String[])normalizedProfiles)).length > 0 && LogbackAccessJoranConfigurator.this.environment.acceptsProfiles(normalizedProfiles);
            ic.addInPlayListener((InPlayListener)this);
        }

        public void inPlay(SaxEvent event) {
            this.events.add(event);
        }

        public void end(InterpretationContext ic, String name) throws ActionException {
            --this.depth;
            if (this.depth != 0) {
                return;
            }
            ic.removeInPlayListener((InPlayListener)this);
            if (this.accepts) {
                this.events.remove(0);
                this.events.remove(this.events.size() - 1);
                ic.getJoranInterpreter().getEventPlayer().addEventsDynamically(this.events, 1);
            }
            this.events.clear();
        }
    }
}

