/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.logback.access;

import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import java.util.Optional;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.rakugakibox.spring.boot.logback.access.AbstractOverridenAttribute;
import net.rakugakibox.spring.boot.logback.access.LogbackAccessSecurityAttributesSaveFilter;
import net.rakugakibox.spring.boot.logback.access.PortRewriteSupport;

public abstract class AbstractLogbackAccessEvent
extends AccessEvent
implements PortRewriteSupport {
    private boolean useServerPortInsteadOfLocalPort;
    private final LocalPort localPort = new LocalPort();
    private final RemoteUser remoteUser = new RemoteUser();

    public AbstractLogbackAccessEvent(HttpServletRequest request, HttpServletResponse response, ServerAdapter adapter) {
        super(request, response, adapter);
        this.setThreadName(Thread.currentThread().getName());
    }

    public int getLocalPort() {
        return (Integer)this.localPort.get();
    }

    public String getRemoteUser() {
        return (String)this.remoteUser.get();
    }

    public boolean isUseServerPortInsteadOfLocalPort() {
        return this.useServerPortInsteadOfLocalPort;
    }

    @Override
    public void setUseServerPortInsteadOfLocalPort(boolean useServerPortInsteadOfLocalPort) {
        this.useServerPortInsteadOfLocalPort = useServerPortInsteadOfLocalPort;
    }

    private class RemoteUser
    extends AbstractOverridenAttribute<String> {
        private RemoteUser() {
        }

        @Override
        protected Optional<String> evaluateValueToOverride() {
            return Optional.of(AbstractLogbackAccessEvent.this).map(AccessEvent::getRequest).map(request -> (String)request.getAttribute(LogbackAccessSecurityAttributesSaveFilter.REMOTE_USER_ATTRIBUTE_NAME));
        }

        @Override
        protected String getOriginalValue() {
            return AbstractLogbackAccessEvent.super.getRemoteUser();
        }
    }

    private class LocalPort
    extends AbstractOverridenAttribute<Integer> {
        private LocalPort() {
        }

        @Override
        protected Optional<Integer> evaluateValueToOverride() {
            return Optional.of(AbstractLogbackAccessEvent.this).filter(AbstractLogbackAccessEvent::isUseServerPortInsteadOfLocalPort).map(AccessEvent::getRequest).map(ServletRequest::getServerPort);
        }

        @Override
        protected Integer getOriginalValue() {
            return AbstractLogbackAccessEvent.super.getLocalPort();
        }
    }
}

