/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.orika;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import net.rakugakibox.spring.boot.orika.OrikaMapperFactoryBuilderConfigurer;
import net.rakugakibox.spring.boot.orika.OrikaMapperFactoryConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OrikaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OrikaAutoConfiguration.class);
    private final List<OrikaMapperFactoryBuilderConfigurer> mapperFactoryBuilderConfigurers;
    private final List<OrikaMapperFactoryConfigurer> mapperFactoryConfigurers;

    @Autowired
    public OrikaAutoConfiguration(Optional<List<OrikaMapperFactoryBuilderConfigurer>> mapperFactoryBuilderConfigurers, Optional<List<OrikaMapperFactoryConfigurer>> mapperFactoryConfigurers) {
        this(mapperFactoryBuilderConfigurers.orElseGet(Collections::emptyList), mapperFactoryConfigurers.orElseGet(Collections::emptyList));
    }

    public OrikaAutoConfiguration(List<OrikaMapperFactoryBuilderConfigurer> mapperFactoryBuilderConfigurers, List<OrikaMapperFactoryConfigurer> mapperFactoryConfigurers) {
        this.mapperFactoryBuilderConfigurers = mapperFactoryBuilderConfigurers;
        this.mapperFactoryConfigurers = mapperFactoryConfigurers;
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultMapperFactory.Builder orikaMapperFactoryBuilder() {
        log.debug("Creating a DefaultMapperFactory.Builder");
        DefaultMapperFactory.Builder mapperFactoryBuilder = new DefaultMapperFactory.Builder();
        this.mapperFactoryBuilderConfigurers.forEach(configurer -> configurer.configure(mapperFactoryBuilder));
        log.debug("Created a DefaultMapperFactory.Builder: [{}]", (Object)mapperFactoryBuilder);
        return mapperFactoryBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperFactory orikaMapperFactory(DefaultMapperFactory.Builder mapperFactoryBuilder) {
        log.debug("Creating a MapperFactory");
        DefaultMapperFactory mapperFactory = mapperFactoryBuilder.build();
        this.mapperFactoryConfigurers.forEach(arg_0 -> OrikaAutoConfiguration.lambda$orikaMapperFactory$1((MapperFactory)mapperFactory, arg_0));
        log.debug("Created a MapperFactory: [{}]", (Object)mapperFactory);
        return mapperFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperFacade orikaMapperFacade(MapperFactory mapperFactory) {
        log.debug("Creating a MapperFactory");
        MapperFacade mapperFacade = mapperFactory.getMapperFacade();
        log.debug("Created a MapperFacade: [{}]", (Object)mapperFacade);
        return mapperFacade;
    }

    private static /* synthetic */ void lambda$orikaMapperFactory$1(MapperFactory mapperFactory, OrikaMapperFactoryConfigurer configurer) {
        configurer.configure(mapperFactory);
    }
}

