/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.orika;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import net.rakugakibox.spring.boot.orika.OrikaMapperFactoryBuilderConfigurer;
import net.rakugakibox.spring.boot.orika.OrikaMapperFactoryConfigurer;
import net.rakugakibox.spring.boot.orika.OrikaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"orika.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={OrikaProperties.class})
public class OrikaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OrikaAutoConfiguration.class);
    private final OrikaProperties orikaProperties;
    private final List<OrikaMapperFactoryBuilderConfigurer> mapperFactoryBuilderConfigurers;
    private final List<OrikaMapperFactoryConfigurer> mapperFactoryConfigurers;

    @Autowired
    public OrikaAutoConfiguration(OrikaProperties orikaProperties, Optional<List<OrikaMapperFactoryBuilderConfigurer>> mapperFactoryBuilderConfigurers, Optional<List<OrikaMapperFactoryConfigurer>> mapperFactoryConfigurers) {
        this(orikaProperties, mapperFactoryBuilderConfigurers.orElseGet(Collections::emptyList), mapperFactoryConfigurers.orElseGet(Collections::emptyList));
    }

    public OrikaAutoConfiguration(OrikaProperties orikaProperties, List<OrikaMapperFactoryBuilderConfigurer> mapperFactoryBuilderConfigurers, List<OrikaMapperFactoryConfigurer> mapperFactoryConfigurers) {
        this.orikaProperties = orikaProperties;
        this.mapperFactoryBuilderConfigurers = mapperFactoryBuilderConfigurers;
        this.mapperFactoryConfigurers = mapperFactoryConfigurers;
    }

    @Bean
    @ConditionalOnMissingBean
    public DefaultMapperFactory.MapperFactoryBuilder<?, ?> orikaMapperFactoryBuilder() {
        log.debug("Creating a MapperFactoryBuilder");
        DefaultMapperFactory.Builder mapperFactoryBuilder = new DefaultMapperFactory.Builder();
        if (this.orikaProperties.getUseBuiltinConverters() != null) {
            mapperFactoryBuilder.useBuiltinConverters(this.orikaProperties.getUseBuiltinConverters().booleanValue());
        }
        if (this.orikaProperties.getUseAutoMapping() != null) {
            mapperFactoryBuilder.useAutoMapping(this.orikaProperties.getUseAutoMapping().booleanValue());
        }
        if (this.orikaProperties.getMapNulls() != null) {
            mapperFactoryBuilder.mapNulls(this.orikaProperties.getMapNulls().booleanValue());
        }
        if (this.orikaProperties.getDumpStateOnException() != null) {
            mapperFactoryBuilder.dumpStateOnException(this.orikaProperties.getDumpStateOnException().booleanValue());
        }
        if (this.orikaProperties.getFavorExtension() != null) {
            mapperFactoryBuilder.favorExtension(this.orikaProperties.getFavorExtension().booleanValue());
        }
        if (this.orikaProperties.getCaptureFieldContext() != null) {
            mapperFactoryBuilder.captureFieldContext(this.orikaProperties.getCaptureFieldContext().booleanValue());
        }
        this.mapperFactoryBuilderConfigurers.forEach(configurer -> configurer.configure((DefaultMapperFactory.MapperFactoryBuilder<?, ?>)mapperFactoryBuilder));
        log.debug("Created a MapperFactoryBuilder: [{}]", (Object)mapperFactoryBuilder);
        return mapperFactoryBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperFactory orikaMapperFactory(DefaultMapperFactory.MapperFactoryBuilder mapperFactoryBuilder) {
        log.debug("Creating a MapperFactory");
        DefaultMapperFactory mapperFactory = mapperFactoryBuilder.build();
        this.mapperFactoryConfigurers.forEach(arg_0 -> OrikaAutoConfiguration.lambda$orikaMapperFactory$1((MapperFactory)mapperFactory, arg_0));
        log.debug("Created a MapperFactory: [{}]", (Object)mapperFactory);
        return mapperFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperFacade orikaMapperFacade(MapperFactory mapperFactory) {
        log.debug("Creating a MapperFactory");
        MapperFacade mapperFacade = mapperFactory.getMapperFacade();
        log.debug("Created a MapperFacade: [{}]", (Object)mapperFacade);
        return mapperFacade;
    }

    private static /* synthetic */ void lambda$orikaMapperFactory$1(MapperFactory mapperFactory, OrikaMapperFactoryConfigurer configurer) {
        configurer.configure(mapperFactory);
    }
}

