/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.spring.boot.orika;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.impl.DefaultMapperFactory;
import net.rakugakibox.spring.boot.orika.OrikaMapperFactoryBuilderConfigurer;
import net.rakugakibox.spring.boot.orika.OrikaMapperFactoryConfigurer;
import net.rakugakibox.spring.boot.orika.OrikaProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"orika.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={OrikaProperties.class})
public class OrikaAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OrikaAutoConfiguration.class);
    private final OrikaProperties orikaProperties;
    private final Optional<List<OrikaMapperFactoryBuilderConfigurer>> orikaMapperFactoryBuilderConfigurers;
    private final Optional<List<OrikaMapperFactoryConfigurer>> orikaMapperFactoryConfigurers;

    @Bean
    @ConditionalOnMissingBean
    public DefaultMapperFactory.MapperFactoryBuilder<?, ?> orikaMapperFactoryBuilder() {
        DefaultMapperFactory.Builder orikaMapperFactoryBuilder = new DefaultMapperFactory.Builder();
        this.orikaProperties.getUseBuiltinConverters().ifPresent(arg_0 -> ((DefaultMapperFactory.Builder)orikaMapperFactoryBuilder).useBuiltinConverters(arg_0));
        this.orikaProperties.getUseAutoMapping().ifPresent(arg_0 -> ((DefaultMapperFactory.Builder)orikaMapperFactoryBuilder).useAutoMapping(arg_0));
        this.orikaProperties.getMapNulls().ifPresent(arg_0 -> ((DefaultMapperFactory.Builder)orikaMapperFactoryBuilder).mapNulls(arg_0));
        this.orikaProperties.getDumpStateOnException().ifPresent(arg_0 -> ((DefaultMapperFactory.Builder)orikaMapperFactoryBuilder).dumpStateOnException(arg_0));
        this.orikaProperties.getFavorExtension().ifPresent(arg_0 -> ((DefaultMapperFactory.Builder)orikaMapperFactoryBuilder).favorExtension(arg_0));
        this.orikaProperties.getCaptureFieldContext().ifPresent(arg_0 -> ((DefaultMapperFactory.Builder)orikaMapperFactoryBuilder).captureFieldContext(arg_0));
        this.orikaMapperFactoryBuilderConfigurers.orElseGet(Collections::emptyList).forEach(configurer -> configurer.configure((DefaultMapperFactory.MapperFactoryBuilder<?, ?>)orikaMapperFactoryBuilder));
        log.debug("Created a MapperFactoryBuilder: [{}]", (Object)orikaMapperFactoryBuilder);
        return orikaMapperFactoryBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperFactory orikaMapperFactory(DefaultMapperFactory.MapperFactoryBuilder<?, ?> orikaMapperFactoryBuilder) {
        DefaultMapperFactory orikaMapperFactory = orikaMapperFactoryBuilder.build();
        this.orikaMapperFactoryConfigurers.orElseGet(Collections::emptyList).forEach(arg_0 -> OrikaAutoConfiguration.lambda$orikaMapperFactory$1((MapperFactory)orikaMapperFactory, arg_0));
        log.debug("Created a MapperFactory: [{}]", (Object)orikaMapperFactory);
        return orikaMapperFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperFacade orikaMapperFacade(MapperFactory orikaMapperFactory) {
        MapperFacade orikaMapperFacade = orikaMapperFactory.getMapperFacade();
        log.debug("Created a MapperFacade: [{}]", (Object)orikaMapperFacade);
        return orikaMapperFacade;
    }

    @ConstructorProperties(value={"orikaProperties", "orikaMapperFactoryBuilderConfigurers", "orikaMapperFactoryConfigurers"})
    public OrikaAutoConfiguration(OrikaProperties orikaProperties, Optional<List<OrikaMapperFactoryBuilderConfigurer>> orikaMapperFactoryBuilderConfigurers, Optional<List<OrikaMapperFactoryConfigurer>> orikaMapperFactoryConfigurers) {
        this.orikaProperties = orikaProperties;
        this.orikaMapperFactoryBuilderConfigurers = orikaMapperFactoryBuilderConfigurers;
        this.orikaMapperFactoryConfigurers = orikaMapperFactoryConfigurers;
    }

    private static /* synthetic */ void lambda$orikaMapperFactory$1(MapperFactory orikaMapperFactory, OrikaMapperFactoryConfigurer configurer) {
        configurer.configure(orikaMapperFactory);
    }
}

