/*
 * Decompiled with CFR 0.152.
 */
package net.rakugakibox.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.yaml.snakeyaml.Yaml;

public class YamlResourceBundle
extends ResourceBundle {
    private final Map<String, Object> entries;

    public YamlResourceBundle(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        this.entries = YamlResourceBundle.flattenYamlTree((Map)new Yaml().loadAs(string, Map.class));
    }

    public YamlResourceBundle(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        this.entries = YamlResourceBundle.flattenYamlTree((Map)new Yaml().loadAs(stream, Map.class));
    }

    public YamlResourceBundle(@NonNull Reader reader) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        this.entries = YamlResourceBundle.flattenYamlTree((Map)new Yaml().loadAs(reader, Map.class));
    }

    private static Map<String, Object> flattenYamlTree(Map<?, ?> map) {
        return map.entrySet().stream().flatMap(YamlResourceBundle::flattenYamlTree).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue(), (oldValue, newValue) -> newValue));
    }

    private static Stream<Map.Entry<String, Object>> flattenYamlTree(Map.Entry<?, ?> entry) {
        String key = entry.getKey().toString();
        Object value = entry.getValue();
        if (value instanceof Map) {
            Map valueAsMap = (Map)value;
            return valueAsMap.entrySet().stream().flatMap(YamlResourceBundle::flattenYamlTree).map(e -> new AbstractMap.SimpleImmutableEntry(key + "." + (String)e.getKey(), e.getValue()));
        }
        if (value instanceof List) {
            List valueAsList = (List)value;
            value = valueAsList.stream().toArray(String[]::new);
            AtomicInteger index = new AtomicInteger();
            return Stream.concat(Stream.of(new AbstractMap.SimpleImmutableEntry(key, value)), valueAsList.stream().map(v -> new AbstractMap.SimpleImmutableEntry<String, Object>(key + "[" + index.getAndIncrement() + "]", v)));
        }
        return Stream.of(new AbstractMap.SimpleImmutableEntry(key, value));
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.entries.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    protected Object handleGetObject(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.entries.get(key);
    }

    public static class Control
    extends ResourceBundle.Control {
        public static final Control INSTANCE = new Control();

        protected Control() {
        }

        @Override
        public List<String> getFormats(@NonNull String baseName) {
            if (baseName == null) {
                throw new NullPointerException("baseName");
            }
            return Collections.unmodifiableList(Arrays.asList("yaml", "yml"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(@NonNull String baseName, @NonNull Locale locale, @NonNull String format, @NonNull ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (baseName == null) {
                throw new NullPointerException("baseName");
            }
            if (locale == null) {
                throw new NullPointerException("locale");
            }
            if (format == null) {
                throw new NullPointerException("format");
            }
            if (loader == null) {
                throw new NullPointerException("loader");
            }
            if (!this.getFormats(baseName).contains(format)) {
                return null;
            }
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, format);
            InputStream stream = loader.getResourceAsStream(resourceName);
            try {
                YamlResourceBundle yamlResourceBundle = new YamlResourceBundle(stream);
                return yamlResourceBundle;
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
    }
}

