/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.embedded;

import java.io.File;
import java.io.IOException;
import net.ravendb.embedded.CopyServerProvider;
import net.ravendb.embedded.ExtractFromZipServerProvider;
import net.ravendb.embedded.IProvideRavenDBServer;

public class ExternalServerProvider
implements IProvideRavenDBServer {
    public static final String SERVER_DLL_FILENAME = "Raven.Server.dll";
    private final String serverLocation;
    private final IProvideRavenDBServer innerProvider;

    public ExternalServerProvider(String serverLocation) {
        this.serverLocation = serverLocation;
        File fileServerLocation = new File(serverLocation);
        if (!fileServerLocation.exists()) {
            throw new IllegalArgumentException("Server location doesn't exist: " + serverLocation);
        }
        if (fileServerLocation.isFile()) {
            this.innerProvider = new ExtractFromZipServerProvider(serverLocation);
            return;
        }
        if (fileServerLocation.isDirectory() && new File(fileServerLocation, SERVER_DLL_FILENAME).exists()) {
            this.innerProvider = new CopyServerProvider(serverLocation);
            return;
        }
        throw new IllegalArgumentException("Unable to find RavenDB server (expected directory with Raven.Server.dll) or zip file. Used directory = " + serverLocation);
    }

    @Override
    public void provide(String targetDirectory) throws IOException {
        this.innerProvider.provide(targetDirectory);
    }
}

