/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.embedded;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ravendb.embedded.IProvideRavenDBServer;
import org.apache.commons.io.IOUtils;

public class ExtractFromZipServerProvider
implements IProvideRavenDBServer {
    private final String sourceLocation;

    public ExtractFromZipServerProvider(String sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    @Override
    public void provide(String targetDirectory) throws IOException {
        try (FileInputStream resourceAsStream = new FileInputStream(this.sourceLocation);){
            ExtractFromZipServerProvider.unzip(resourceAsStream, targetDirectory);
        }
    }

    public static void unzip(InputStream source, String out) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(source);){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                File file = new File(out, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                } else {
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
                        IOUtils.copy((InputStream)zis, (OutputStream)bos);
                    }
                }
                entry = zis.getNextEntry();
            }
        }
    }
}

