/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.embedded;

import com.google.common.base.Stopwatch;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.ravendb.client.documents.DocumentStore;
import net.ravendb.client.documents.IDocumentStore;
import net.ravendb.client.documents.Lazy;
import net.ravendb.client.exceptions.ConcurrencyException;
import net.ravendb.client.exceptions.RavenException;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.primitives.Tuple;
import net.ravendb.client.serverwide.operations.CreateDatabaseOperation;
import net.ravendb.client.serverwide.operations.IServerOperation;
import net.ravendb.embedded.DatabaseOptions;
import net.ravendb.embedded.RavenServerRunner;
import net.ravendb.embedded.ServerOptions;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmbeddedServer
implements CleanCloseable {
    public static EmbeddedServer INSTANCE = new EmbeddedServer();
    public static final String END_OF_STREAM_MARKER = "$$END_OF_STREAM$$";
    private static final Log logger = LogFactory.getLog(EmbeddedServer.class);
    private final AtomicReference<Lazy<Tuple<String, Process>>> _serverTask = new AtomicReference();
    private final ConcurrentMap<String, Lazy<IDocumentStore>> _documentStores = new ConcurrentHashMap<String, Lazy<IDocumentStore>>();
    private KeyStore _certificate;
    private KeyStore _trustStore;
    private Duration _gracefulShutdownTimeout;

    public void startServer() {
        this.startServer(null);
    }

    public void startServer(ServerOptions optionsParam) {
        ServerOptions options = (ServerOptions)ObjectUtils.firstNonNull((Object[])new ServerOptions[]{optionsParam, ServerOptions.INSTANCE});
        this._gracefulShutdownTimeout = options.getGracefulShutdownTimeout();
        Lazy startServer = new Lazy(() -> this.runServer(options));
        if (!this._serverTask.compareAndSet(null, (Lazy<Tuple<String, Process>>)startServer)) {
            throw new IllegalStateException("The server was already started");
        }
        if (options.getSecurity() != null) {
            this._certificate = options.getSecurity().getClientCertificate();
            this._trustStore = options.getSecurity().getTrustStore();
        }
        startServer.getValue();
    }

    public IDocumentStore getDocumentStore(String database) {
        return this.getDocumentStore(new DatabaseOptions(database));
    }

    public IDocumentStore getDocumentStore(DatabaseOptions options) {
        String databaseName = options.getDatabaseRecord().getDatabaseName();
        if (StringUtils.isBlank((CharSequence)databaseName)) {
            throw new IllegalArgumentException("DatabaseName cannot be null or whitespace");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating document store for '" + databaseName + "'."));
        }
        Lazy lazy = new Lazy(() -> {
            String serverUrl = this.getServerUri();
            DocumentStore store = new DocumentStore(serverUrl, databaseName);
            store.setCertificate(this._certificate);
            store.setTrustStore(this._trustStore);
            store.setConventions(options.getConventions());
            store.addAfterCloseListener((sender, event) -> this._documentStores.remove(databaseName));
            store.initialize();
            if (!options.isSkipCreatingDatabase()) {
                this.tryCreateDatabase(options, (IDocumentStore)store);
            }
            return store;
        });
        return (IDocumentStore)this._documentStores.computeIfAbsent(databaseName, dbName -> lazy).getValue();
    }

    private void tryCreateDatabase(DatabaseOptions options, IDocumentStore store) {
        block2: {
            try {
                store.maintenance().server().send((IServerOperation)new CreateDatabaseOperation(options.getDatabaseRecord()));
            }
            catch (ConcurrencyException e) {
                if (!logger.isInfoEnabled()) break block2;
                logger.info((Object)(options.getDatabaseRecord().getDatabaseName() + " already exists."));
            }
        }
    }

    public String getServerUri() {
        AtomicReference<Lazy<Tuple<String, Process>>> server = this._serverTask;
        if (server.get() == null) {
            throw new IllegalStateException("Please run startServer() before trying to use the server.");
        }
        return (String)((Tuple)server.get().getValue()).first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownServerProcess(Process process) {
        if (process == null || !process.isAlive()) {
            return;
        }
        Process process2 = process;
        synchronized (process2) {
            block25: {
                block24: {
                    if (!process.isAlive()) {
                        return;
                    }
                    try {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"Try shutdown server gracefully.");
                        }
                        try (OutputStream stream = process.getOutputStream();
                             PrintWriter writer = new PrintWriter(stream);){
                            writer.println("shutdown no-confirmation");
                        }
                        if (process.waitFor(this._gracefulShutdownTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isInfoEnabled()) break block24;
                        logger.info((Object)("Failed to gracefully shutdown server in " + this._gracefulShutdownTimeout.toString()), (Throwable)e);
                    }
                }
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)"Killing global server");
                    }
                    process.destroyForcibly().waitFor();
                }
                catch (Exception e) {
                    if (!logger.isInfoEnabled()) break block25;
                    logger.info((Object)"Failed to kill server process.");
                }
            }
        }
    }

    private Tuple<String, Process> runServer(ServerOptions options) {
        try {
            if (options.isClearTargetServerLocation()) {
                FileUtils.deleteDirectory((File)new File(options.getTargetServerLocation()));
            }
            options.provider.provide(options.getTargetServerLocation());
        }
        catch (IOException e) {
            logger.error((Object)("Failed to spawn server files. " + e.getMessage()), (Throwable)e);
            throw new IllegalStateException("Failed to spawn server files. " + e.getMessage(), e);
        }
        Process process = RavenServerRunner.run(options);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Starting global server");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdownServerProcess(process)));
        Reference urlRef = new Reference();
        Stopwatch startupDuration = Stopwatch.createStarted();
        String outputString = EmbeddedServer.readOutput(process.getInputStream(), startupDuration, options, (line, builder) -> {
            if (line == null) {
                String errorString = EmbeddedServer.readOutput(process.getErrorStream(), startupDuration, options, null);
                this.shutdownServerProcess(process);
                throw new IllegalStateException(EmbeddedServer.buildStartupExceptionMessage(builder.toString(), errorString));
            }
            String prefix = "Server available on: ";
            if (line.startsWith(prefix)) {
                urlRef.value = line.substring(prefix.length());
                return true;
            }
            return false;
        });
        if (urlRef.value == null) {
            String errorString = EmbeddedServer.readOutput(process.getErrorStream(), startupDuration, options, null);
            this.shutdownServerProcess(process);
            throw new IllegalStateException(EmbeddedServer.buildStartupExceptionMessage(outputString, errorString));
        }
        return Tuple.create((Object)((String)urlRef.value), (Object)process);
    }

    private static String buildStartupExceptionMessage(String outputString, String errorString) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to start the RavenDB Server");
        sb.append(System.lineSeparator());
        if (StringUtils.isNotBlank((CharSequence)errorString)) {
            sb.append("Error:");
            sb.append(System.lineSeparator());
            sb.append(errorString);
            sb.append(System.lineSeparator());
        }
        if (StringUtils.isNotBlank((CharSequence)outputString)) {
            sb.append("Output:");
            sb.append(System.lineSeparator());
            sb.append(outputString);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String readOutput(InputStream output, Stopwatch startupDuration, ServerOptions options, BiFunction<String, StringBuilder, Boolean> online) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(output));
        ArrayBlockingQueue readQueue = new ArrayBlockingQueue(50);
        CompletableFuture.runAsync(() -> {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    readQueue.add(line);
                }
                readQueue.add(END_OF_STREAM_MARKER);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                String line = (String)readQueue.poll(5L, TimeUnit.SECONDS);
                if (options.getMaxServerStartupTimeDuration().minus(startupDuration.elapsed()).isNegative()) {
                    return null;
                }
                if (line == null) continue;
                if (END_OF_STREAM_MARKER.equals(line)) {
                    line = null;
                }
                if (line != null) {
                    sb.append(line);
                    sb.append(System.lineSeparator());
                }
                Reference shouldStop = new Reference((Object)false);
                if (online != null) {
                    shouldStop.value = online.apply(line, sb);
                }
                if (((Boolean)shouldStop.value).booleanValue() || line == null) break;
            }
        }
        catch (InterruptedException e) {
            throw new RavenException("Unable to read server output: " + e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public void openStudioInBrowser() {
        String serverUrl = this.getServerUri();
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(new URI(serverUrl));
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.exec("xdg-open " + serverUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        Lazy lazy = this._serverTask.getAndSet(null);
        if (lazy == null || !lazy.isValueCreated()) {
            return;
        }
        Process process = (Process)((Tuple)lazy.getValue()).second;
        this.shutdownServerProcess(process);
        for (Map.Entry item : this._documentStores.entrySet()) {
            if (!((Lazy)item.getValue()).isValueCreated()) continue;
            ((IDocumentStore)((Lazy)item.getValue()).getValue()).close();
        }
        this._documentStores.clear();
    }
}

