/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.embedded;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.ravendb.client.primitives.Tuple;
import net.ravendb.embedded.ServerOptions;
import org.apache.commons.lang3.StringUtils;

public class RuntimeFrameworkVersionMatcher {
    private static final String WILDCARD = "x";
    public static final char GREATER_OR_EQUAL = '+';

    public static String match(ServerOptions options) {
        if (!RuntimeFrameworkVersionMatcher.needsMatch(options)) {
            return options != null ? options.getFrameworkVersion() : null;
        }
        RuntimeFrameworkVersion runtime = new RuntimeFrameworkVersion(options.getFrameworkVersion());
        List<RuntimeFrameworkVersion> runtimes = RuntimeFrameworkVersionMatcher.getFrameworkVersions(options);
        return RuntimeFrameworkVersionMatcher.match(runtime, runtimes);
    }

    public static String match(RuntimeFrameworkVersion runtime, List<RuntimeFrameworkVersion> runtimes) {
        List sortedRuntimes = runtimes.stream().sorted(Comparator.comparingInt(RuntimeFrameworkVersion::getMajor).thenComparingInt(RuntimeFrameworkVersion::getMinor).thenComparingInt(RuntimeFrameworkVersion::getPatch).reversed()).collect(Collectors.toList());
        for (RuntimeFrameworkVersion version : sortedRuntimes) {
            if (!runtime.match(version)) continue;
            return version.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not find a matching runtime for '").append(runtime).append("'. Available runtimes:");
        sb.append(System.lineSeparator());
        for (RuntimeFrameworkVersion r : sortedRuntimes) {
            sb.append("- ").append(r);
        }
        throw new IllegalStateException(sb.toString());
    }

    private static boolean needsMatch(ServerOptions options) {
        if (options == null || StringUtils.isBlank((CharSequence)options.getFrameworkVersion())) {
            return false;
        }
        String frameworkVersionAsString = options.getFrameworkVersion().toLowerCase();
        return frameworkVersionAsString.contains(WILDCARD) || frameworkVersionAsString.contains(String.valueOf('+'));
    }

    private static List<RuntimeFrameworkVersion> getFrameworkVersions(ServerOptions options) {
        if (StringUtils.isBlank((CharSequence)options.getDotNetPath())) {
            throw new IllegalStateException();
        }
        ProcessBuilder processBuilder = new ProcessBuilder(options.getDotNetPath(), "--info");
        Process process = null;
        try {
            process = processBuilder.start();
            String line = null;
            boolean insideRuntimes = false;
            ArrayList<String> runtimeLines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith(".NET runtimes installed:") || line.startsWith(".NET Core runtimes installed:")) {
                    insideRuntimes = true;
                    continue;
                }
                if (!insideRuntimes || !line.startsWith("Microsoft.NETCore.App")) continue;
                runtimeLines.add(line);
            }
            ArrayList<RuntimeFrameworkVersion> runtimes = new ArrayList<RuntimeFrameworkVersion>();
            for (String runtimeLine : runtimeLines) {
                String[] values = runtimeLine.split(" ");
                if (values.length < 2) {
                    throw new IllegalStateException("Invalid runtime line. Expected 'Microsoft.NETCore.App x.x.x', but was '" + runtimeLine + "'");
                }
                runtimes.add(new RuntimeFrameworkVersion(values[1]));
            }
            ArrayList<RuntimeFrameworkVersion> arrayList = runtimes;
            return arrayList;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to execute dotnet to retrieve list of installed runtimes", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    public static class RuntimeFrameworkVersion {
        private static final String SEPARATORS = ".";
        private static final String SUFFIX_SEPARATOR = "-";
        private Integer major;
        private Integer minor;
        private Integer patch;
        private MatchingType patchMatchingType;
        private String suffix;

        public RuntimeFrameworkVersion(String frameworkVersion) {
            frameworkVersion = frameworkVersion.toLowerCase();
            List suffixes = Arrays.stream(frameworkVersion.split(SUFFIX_SEPARATOR)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (suffixes.size() != 1) {
                frameworkVersion = (String)suffixes.get(0);
                this.suffix = suffixes.stream().skip(1L).collect(Collectors.joining(SUFFIX_SEPARATOR));
            }
            List versions = Arrays.stream(StringUtils.split((String)frameworkVersion, (String)SEPARATORS)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            for (int i = 0; i < versions.size(); ++i) {
                String version = ((String)versions.get(i)).trim();
                if (!version.contains(RuntimeFrameworkVersionMatcher.WILDCARD)) {
                    Tuple<Integer, MatchingType> tuple = RuntimeFrameworkVersion.parse(version);
                    this.set(i, version, (Integer)tuple.first, (MatchingType)((Object)tuple.second));
                    continue;
                }
                if (!version.equals(RuntimeFrameworkVersionMatcher.WILDCARD)) {
                    throw new IllegalStateException("Wildcard character must be a sole part of the version string, but was '" + version + "'.");
                }
                this.set(i, null, null, MatchingType.EQUAL);
            }
        }

        public Integer getMajor() {
            return this.major;
        }

        public Integer getMinor() {
            return this.minor;
        }

        public Integer getPatch() {
            return this.patch;
        }

        public void setPatch(Integer patch) {
            this.patch = patch;
        }

        public MatchingType getPatchMatchingType() {
            return this.patchMatchingType;
        }

        public String getSuffix() {
            return this.suffix;
        }

        private static String toStringInterval(Integer number, MatchingType matchingType) {
            if (number == null) {
                return RuntimeFrameworkVersionMatcher.WILDCARD;
            }
            switch (matchingType.ordinal()) {
                case 0: {
                    return number.toString();
                }
                case 1: {
                    return number.toString() + '+';
                }
            }
            throw new IllegalArgumentException("Invalid matching type: " + (Object)((Object)matchingType));
        }

        public String toString() {
            String s1 = RuntimeFrameworkVersion.toStringInterval(this.major, MatchingType.EQUAL);
            String s2 = RuntimeFrameworkVersion.toStringInterval(this.minor, MatchingType.EQUAL);
            String s3 = RuntimeFrameworkVersion.toStringInterval(this.patch, this.patchMatchingType);
            String version = s1 + SEPARATORS + s2 + SEPARATORS + s3;
            if (this.suffix != null) {
                version = version + SUFFIX_SEPARATOR + this.suffix;
            }
            return version;
        }

        private static Tuple<Integer, MatchingType> parse(String value) {
            MatchingType matchingType = MatchingType.EQUAL;
            String valueToParse = value;
            char lastChar = valueToParse.charAt(valueToParse.length() - 1);
            if (lastChar == '+') {
                matchingType = MatchingType.GREATER_OR_EQUAL;
                valueToParse = valueToParse.substring(0, valueToParse.length() - 1);
            }
            int valueAsInt = Integer.parseInt(valueToParse);
            return Tuple.create((Object)valueAsInt, (Object)((Object)matchingType));
        }

        private void set(int i, String valueAsString, Integer value, MatchingType matchingType) {
            switch (i) {
                case 0: {
                    this.assertMatchingType("major", valueAsString, MatchingType.EQUAL, matchingType);
                    this.major = value;
                    break;
                }
                case 1: {
                    this.assertMatchingType("minor", valueAsString, MatchingType.EQUAL, matchingType);
                    this.minor = value;
                    break;
                }
                case 2: {
                    this.assertMatchingType("patch", valueAsString, null, matchingType);
                    this.patch = value;
                    this.patchMatchingType = matchingType;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        private void assertMatchingType(String fieldName, String valueAsString, MatchingType expectedMatchingType, MatchingType matchingType) {
            if (this.suffix != null && matchingType != MatchingType.EQUAL) {
                throw new IllegalStateException("Cannot set '" + fieldName + "' with value '" + valueAsString + "' because '" + RuntimeFrameworkVersion.matchingTypeToString(matchingType) + "' is not allowed when suffix ('" + this.suffix + "') is set.");
            }
            if (expectedMatchingType != null && expectedMatchingType != matchingType) {
                throw new IllegalStateException("Cannot set '" + fieldName + "' with value '" + valueAsString + "' because '" + RuntimeFrameworkVersion.matchingTypeToString(matchingType) + "' is not allowed.");
            }
        }

        private static String matchingTypeToString(MatchingType matchingType) {
            switch (matchingType.ordinal()) {
                case 0: {
                    return "";
                }
                case 1: {
                    return String.valueOf('+');
                }
            }
            throw new IllegalArgumentException("Illegal matching type: " + (Object)((Object)matchingType));
        }

        public boolean match(RuntimeFrameworkVersion version) {
            if (this.major != null && !this.major.equals(version.getMajor())) {
                return false;
            }
            if (this.minor != null && !this.minor.equals(version.getMinor())) {
                return false;
            }
            if (this.patch != null) {
                switch (this.patchMatchingType.ordinal()) {
                    case 0: {
                        if (this.patch.equals(version.getPatch())) break;
                        return false;
                    }
                    case 1: {
                        if (this.patch <= version.getPatch()) break;
                        return false;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            return StringUtils.equals((CharSequence)this.suffix, (CharSequence)version.getSuffix());
        }
    }

    public static enum MatchingType {
        EQUAL,
        GREATER_OR_EQUAL;

    }
}

