/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.binary.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.library.binary.file.BinaryFileProcessorHandler;
import net.reyadeyat.api.library.environment.ApiEnvironment;
import net.reyadeyat.api.library.json.JsonUtil;
import net.reyadeyat.api.library.process.BackgroundProcess;
import net.reyadeyat.api.library.process.BackgroundProcessScheduler;

public class BinaryFileProcess
extends BackgroundProcess {
    private static final String process_name = "Binary File Process";

    public BinaryFileProcess(BackgroundProcessScheduler background_process_scheduler) throws Exception {
        super(background_process_scheduler);
        this.startTask(this::buildFileProcess);
    }

    public void buildFileProcess() {
        try {
            File temp_binary_file_upload_path = new File(ApiEnvironment.getProperty("net.reyadeyat.api.library.binary.file.process.temp_binary_file_upload_path"));
            if (temp_binary_file_upload_path == null) {
                return;
            }
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Binary File Process doing some work on background thread '" + Thread.currentThread().getName() + "'");
            String file_processor_map_text = ApiEnvironment.getProperty("net.reyadeyat.api.library.binary.file.process.processor");
            final JsonObject file_processor_map = JsonUtil.jsonStringToObject(file_processor_map_text, JsonObject.class);
            Files.walkFileTree(temp_binary_file_upload_path.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file_path, BasicFileAttributes attrs) throws IOException {
                    JsonArray errors = new JsonArray();
                    try {
                        String extension = file_path.toString();
                        extension = extension.substring(extension.lastIndexOf("."));
                        if (!file_processor_map.has(extension)) {
                            return FileVisitResult.CONTINUE;
                        }
                        String processor_class_path = file_processor_map.get(extension).getAsJsonObject().get("processor").getAsString();
                        Class<?> processorClass = Class.forName(processor_class_path);
                        Constructor<?> constructor = processorClass.getConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        Object processor = constructor.newInstance(new Object[0]);
                        String upload_location = ApiEnvironment.getProperty("net.reyadeyat.api.library.binary.file.process.upload.location");
                        Boolean delete = ((BinaryFileProcessorHandler)processor).processBinaryFile(file_path, upload_location, errors);
                        if (delete.booleanValue()) {
                            Files.delete(file_path);
                        }
                    }
                    catch (Exception ex) {
                        StringBuilder error_message = new StringBuilder();
                        for (int i = 0; i < errors.size(); ++i) {
                            error_message.append(errors.get(i).getAsString()).append("\n");
                        }
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Binary File Process Runtime Exception on yprocess 'Binary File Process' while processing file '" + file_path.toString() + "'\n" + error_message.toString() + ", Contact Administrator\n" + ex.getMessage(), ex);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException("Binary File Process Process Runtime Exception '" + this.background_process_scheduler.getDescription() + ".Binary File Process', Contact Administrator\n" + ex.getMessage(), ex);
        }
    }
}

