/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.binary.file;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.library.binary.file.BinaryFileProcessorHandler;
import net.reyadeyat.api.library.binary.file.ChunkedFile;
import net.reyadeyat.api.library.binary.file.DataChunk;
import net.reyadeyat.api.library.logger.EmbeddedLevel;

public class BinaryFileProcessor
implements BinaryFileProcessorHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean processBinaryFile(Path binary_file_path, String upload_location, JsonArray errors) throws Exception {
        try (FileChannel file = FileChannel.open(binary_file_path, StandardOpenOption.READ);){
            JsonObject file_info_json;
            String file_info_json_text;
            String file_key;
            ChunkedFile chunked_file = new ChunkedFile(file);
            if (!chunked_file.isCompleteFile().booleanValue()) {
                file.close();
                Logger.getLogger(this.getClass().getName()).log((Level)EmbeddedLevel.NOTE, "Binary file is not valid:\n" + chunked_file.toString());
                Boolean bl = false;
                return bl;
            }
            String chunked_file_key = chunked_file.getFileKey();
            try {
                Gson gson = new Gson();
                file_key = chunked_file.getFileKey();
                file_info_json_text = chunked_file.getFileInfo();
                file_info_json = (JsonObject)gson.fromJson(file_info_json_text, JsonObject.class);
                if (!file_info_json.get("file_process").getAsString().equals(this.getClass().getSimpleName())) {
                    file.close();
                    Boolean bl = false;
                    return bl;
                }
            }
            catch (Exception ex) {
                errors.add("Error processing chunk for file '" + chunked_file_key + "'");
                throw ex;
            }
            {
                Logger.getLogger(this.getClass().getName()).log((Level)EmbeddedLevel.DATA, "file_key: " + file_key);
                Logger.getLogger(this.getClass().getName()).log((Level)EmbeddedLevel.DATA, "file_info: " + file_info_json_text);
                String file_name = file_info_json.get("file_name").getAsString();
                File binary_file = new File(upload_location + File.separator + file_key + "." + file_name);
                try (FileOutputStream fos = new FileOutputStream(binary_file);){
                    for (int i = 0; i < chunked_file.getChunkCount(); ++i) {
                        DataChunk data_chunk = chunked_file.readChunk(i);
                        fos.write(data_chunk.chunk_blob_bytes);
                    }
                }
                if (!Logger.getLogger(this.getClass().getName()).isLoggable(EmbeddedLevel.TRACE)) return true;
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    Logger.getLogger(this.getClass().getName()).log((Level)EmbeddedLevel.TRACE, "Report file is succefully loaded:\n" + chunked_file.toString());
                    return true;
                }
            }
        }
        catch (Exception ex) {
            errors.add("Error processing chunk for file '" + binary_file_path.toString() + "'");
            throw ex;
        }
    }
}

