/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.binary.file;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.library.binary.file.ChunkedFile;
import net.reyadeyat.api.library.environment.ApiEnvironment;
import net.reyadeyat.api.library.logger.EmbeddedLevel;
import net.reyadeyat.api.library.servlet.ServletData;
import net.reyadeyat.api.library.servlet.TransactionServlet;

public class BinaryFileUploadServlet
extends TransactionServlet {
    private final ServletData binary_file_upload_servlet_data;
    private final String temp_binary_file_upload_path;
    private final Map<String, Object> file_map = new ConcurrentHashMap<String, Object>();

    public BinaryFileUploadServlet() {
        super("Binary File Upload");
        this.temp_binary_file_upload_path = ApiEnvironment.getProperty("net.reyadeyat.api.library.binary.file.process.temp_binary_file_upload_path");
        File file = new File(this.temp_binary_file_upload_path);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.binary_file_upload_servlet_data = new ServletData("Binary File Upload Servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void binary_file_upload(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        Object file_instant;
        String lang = "ar";
        String file_upload_key = null;
        Long file_length = null;
        Integer chunk_count = null;
        String file_key = null;
        String file_extension = null;
        String file_info = null;
        Integer chunk_index = null;
        Integer chunk_legth = null;
        String chunk_blob_base64 = null;
        String[] parameter_list = new String[]{"lang", "file_upload_key", "file_key", "file_extension", "file_info", "file_length", "chunk_count", "chunk_index", "chunk_legth", "chunk_blob_base64"};
        JsonArray error_list = new JsonArray();
        if (this.isValid(parameter_list, req, error_list)) {
            lang = req.getParameter("lang");
            file_upload_key = req.getParameter("file_upload_key");
            file_key = req.getParameter("file_key");
            file_extension = req.getParameter("file_extension");
            file_info = req.getParameter("file_info");
            file_length = Long.valueOf(req.getParameter("file_length"));
            chunk_count = Integer.valueOf(req.getParameter("chunk_count"));
            Map<String, Object> map = this.file_map;
            synchronized (map) {
                this.file_map.put(file_key, new Object());
            }
        } else {
            JsonObject response = this.createJsonResponseObject(false, 400, 400, "errors", error_list);
            this.sendReponse(req, resp, response);
            return;
        }
        chunk_index = Integer.valueOf(req.getParameter("chunk_index"));
        chunk_legth = Integer.valueOf(req.getParameter("chunk_legth"));
        chunk_blob_base64 = this.getUploadedFileString(req, "chunk_blob_base64");
        File temp_report_path_directory = new File(this.temp_binary_file_upload_path);
        if (!temp_report_path_directory.exists()) {
            error_list.add("report path is null");
            JsonObject response = this.createJsonResponseObject(false, 400, 400, "errors", error_list);
            this.sendReponse(req, resp, response);
            return;
        }
        Object object = file_instant = this.file_map.get(file_key);
        synchronized (object) {
            File binary_file = new File(this.temp_binary_file_upload_path + "/" + file_key + file_extension);
            if (this.temp_binary_file_upload_path.startsWith(".")) {
                binary_file = new File(binary_file.getAbsolutePath().replaceAll("\\.\\/", ""));
            }
            if (!Files.exists(binary_file.toPath(), new LinkOption[0])) {
                Files.createFile(binary_file.toPath(), new FileAttribute[0]);
                Logger.getLogger(this.getClass().getName()).log((Level)EmbeddedLevel.TRACE, "Binary File Upload '" + binary_file.toPath().toString() + "' created successfully.");
            }
            try (FileChannel file = FileChannel.open(binary_file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
                Base64.Decoder base64_decoder = Base64.getDecoder();
                ChunkedFile chunked_file = file.size() == 0L ? new ChunkedFile(file, file_key, file_info, file_length, chunk_count) : new ChunkedFile(file);
                byte[] chunk_blob_bytes = base64_decoder.decode(chunk_blob_base64);
                if (chunk_legth != chunk_blob_bytes.length) {
                    throw new Exception("Chunk[" + chunk_index + "] => chunk_legth[" + chunk_legth + "] != chunk_blob_bytes_length[" + chunk_blob_bytes.length + "]");
                }
                chunked_file.appendChunk(chunk_index, chunk_blob_bytes);
                chunked_file.save();
                Logger.getLogger(this.getClass().getName()).log((Level)EmbeddedLevel.TRACE, "committed binary file '" + file_key + "' chunk_index[" + chunk_index + "] => chunk_legth[" + chunk_legth + "]");
            }
            catch (Exception ex) {
                error_list.add("Error processing chunk for file '" + file_key + "' => " + ex.getMessage());
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error processing chunk for file '" + file_key + "' => " + ex.getMessage(), ex);
            }
        }
        if (error_list.size() == 0) {
            response = this.createJsonResponseObject(true, 200, 200, "sucess");
            response.addProperty("INFO", "Exceution time");
            this.sendReponse(req, resp, response);
        } else {
            error_list.add("rollback on errors");
            response = this.createJsonResponseObject(false, 400, 400, "errors", error_list);
            this.sendReponse(req, resp, response);
        }
    }
}

