/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.binary.file;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.time.Instant;
import java.util.Base64;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.reyadeyat.api.library.binary.file.ChunkedFileChunk;
import net.reyadeyat.api.library.binary.file.ChunkedFileHeader;
import net.reyadeyat.api.library.binary.file.DataChunk;

public class ChunkedFile
implements Comparable<Object> {
    private final FileChannel file;
    private final ChunkedFileHeader chunked_file_header;
    public final Instant now = Instant.now();

    public ChunkedFile(FileChannel file) throws Exception {
        this.file = file;
        this.chunked_file_header = new ChunkedFileHeader(file);
    }

    public ChunkedFile(FileChannel file, String file_key, String file_info, long file_length, int chunk_count) throws Exception {
        this.file = file;
        this.chunked_file_header = new ChunkedFileHeader(file, file_key, file_info, file_length, chunk_count);
    }

    public void appendChunk(int chunk_index, byte[] chunk_blob_bytes) throws Exception {
        long chunk_pointer = this.file.size();
        ChunkedFileChunk chunked_file_chunk = new ChunkedFileChunk(this.file, chunk_index, chunk_pointer, chunk_blob_bytes);
        this.chunked_file_header.updateHeader(this.file, chunked_file_chunk);
    }

    public DataChunk readChunk(int index) throws Exception {
        int chunk_length;
        long chunk_pointer = this.chunked_file_header.getChunkPointer(index);
        if (chunk_pointer + (long)(chunk_length = this.chunked_file_header.getChunkLength(index)) > this.file.size()) {
            throw new IOException("File '" + this.chunked_file_header.getFileKey() + "' chunk_end position '" + (chunk_pointer + (long)chunk_length) + "' passes file size '" + this.file.size() + "'");
        }
        ChunkedFileChunk chunked_file_chunk = new ChunkedFileChunk(this.file, index, chunk_pointer, chunk_length);
        DataChunk data_chunk = chunked_file_chunk.getDataChunk();
        return data_chunk;
    }

    public Boolean isCompleteFile() {
        return this.chunked_file_header.isFileLengthComplete() != false && this.chunked_file_header.isChucnkCountComplete() != false;
    }

    public long getFileLength() {
        return this.chunked_file_header.getFileLength();
    }

    public int getChunkCount() {
        return this.chunked_file_header.getChunkCount();
    }

    public String getFileKey() {
        return this.chunked_file_header.getFileKey();
    }

    public String getFileInfo() {
        return this.chunked_file_header.getFileInfo();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ChunkedFile) {
            ChunkedFile this2 = (ChunkedFile)object;
            return this2.chunked_file_header.getFileKey().equals(this.chunked_file_header.getFileKey());
        }
        return this.chunked_file_header.getFileKey().equals((String)object);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.file);
        hash = 41 * hash + Objects.hashCode(this.chunked_file_header);
        return hash;
    }

    @Override
    public int compareTo(Object object) {
        if (this.equals(object)) {
            return 0;
        }
        if (object instanceof ChunkedFile) {
            ChunkedFile chunked_file = (ChunkedFile)object;
            return this.chunked_file_header.getFileKey().compareTo(chunked_file.chunked_file_header.getFileKey());
        }
        return this.chunked_file_header.getFileKey().compareTo((String)object);
    }

    public void printFileStructure() throws Exception {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "\nprintFileStructure() - start");
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "\nchunked_file_header:\n" + String.valueOf(this.chunked_file_header));
        if (!this.isCompleteFile().booleanValue()) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "chunked_file.isCompleteFile() == false");
            return;
        }
        Base64.Decoder decoderBase64 = Base64.getDecoder();
        for (int index = 0; index < this.getChunkCount(); ++index) {
            DataChunk data_chunk = this.readChunk(index);
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "\nDataChunk :\n" + String.valueOf(data_chunk));
        }
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "\nprintFileStructure() - end.");
    }

    public void save() throws Exception {
        this.file.force(true);
    }

    public String toString(Boolean extend) {
        return this.chunked_file_header.toString(extend);
    }

    public String toString() {
        return this.chunked_file_header.toString();
    }
}

