/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.binary.file;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import net.reyadeyat.api.library.binary.file.ChunkedFileChunk;
import net.reyadeyat.api.library.binary.file.MemoryUtils;

public class ChunkedFileHeader {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
    long file_length;
    long current_file_length;
    int chunk_count;
    int current_chunk_count;
    int file_key_bytes_size;
    int file_info_bytes_size;
    byte[] chunk_header;
    String file_key;
    String file_info;
    private long createion_timestamp;
    private long modification_timestamp;
    private transient byte[] timestamp;
    int header_size;
    private static final DecimalFormat df = new DecimalFormat("#,##0.00");

    public ChunkedFileHeader(FileChannel file, String file_key, String file_info, long file_length, int chunk_count) throws Exception {
        this.current_file_length = 0L;
        this.chunk_count = chunk_count;
        this.current_chunk_count = 0;
        this.file_key = file_key;
        byte[] file_key_bytes = file_key.getBytes(StandardCharsets.UTF_8);
        this.file_key_bytes_size = file_key_bytes.length;
        this.file_info = file_info;
        byte[] file_info_bytes = file_info.getBytes(StandardCharsets.UTF_8);
        this.file_info_bytes_size = file_info_bytes.length;
        this.chunk_header = new byte[this.chunk_count * 12];
        this.timestamp = new byte[32];
        this.createion_timestamp = Instant.now().toEpochMilli();
        this.modification_timestamp = Instant.now().toEpochMilli();
        MemoryUtils.setLongAt(this.timestamp, this.createion_timestamp, 8);
        MemoryUtils.setLongAt(this.timestamp, this.modification_timestamp, 24);
        this.header_size = 64 + chunk_count * 12 + this.file_key_bytes_size + this.file_info_bytes_size;
        ByteBuffer buffer = ByteBuffer.allocate(this.header_size);
        this.file_length = file_length + (long)this.header_size;
        buffer.putLong(file_length);
        buffer.putLong(this.current_file_length);
        buffer.putInt(chunk_count);
        buffer.putInt(this.current_chunk_count);
        buffer.putInt(this.file_key_bytes_size);
        buffer.putInt(this.file_info_bytes_size);
        buffer.put(this.timestamp);
        buffer.put(this.chunk_header);
        buffer.put(file_key_bytes);
        buffer.put(file_info_bytes);
        buffer.flip();
        file.write(buffer);
    }

    public ChunkedFileHeader(FileChannel file) throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        file.read(buffer);
        buffer.flip();
        this.file_length = buffer.getLong();
        this.current_file_length = buffer.getLong();
        this.chunk_count = buffer.getInt();
        this.current_chunk_count = buffer.getInt();
        this.file_key_bytes_size = buffer.getInt();
        this.file_info_bytes_size = buffer.getInt();
        this.timestamp = new byte[32];
        buffer.get(this.timestamp);
        this.createion_timestamp = MemoryUtils.getLongAt(this.timestamp, 8);
        this.modification_timestamp = MemoryUtils.getLongAt(this.timestamp, 24);
        this.chunk_header = new byte[this.chunk_count * 12];
        this.header_size = 64 + this.chunk_count * 12 + this.file_key_bytes_size + this.file_info_bytes_size;
        buffer = ByteBuffer.allocate(this.chunk_header.length);
        file.read(buffer);
        buffer.flip();
        buffer.get(this.chunk_header);
        byte[] file_key_bytes = new byte[this.file_key_bytes_size];
        buffer = ByteBuffer.allocate(this.file_key_bytes_size);
        file.read(buffer);
        buffer.flip();
        buffer.get(file_key_bytes);
        this.file_key = new String(file_key_bytes, StandardCharsets.UTF_8);
        byte[] file_info_bytes = new byte[this.file_info_bytes_size];
        buffer = ByteBuffer.allocate(this.file_info_bytes_size);
        file.read(buffer);
        buffer.flip();
        buffer.get(file_info_bytes);
        this.file_info = new String(file_info_bytes, StandardCharsets.UTF_8);
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    public Boolean isFileLengthComplete() {
        return this.file_length == this.current_file_length;
    }

    public Boolean isChucnkCountComplete() {
        return this.chunk_count == this.current_chunk_count;
    }

    public void updateHeader(FileChannel file, ChunkedFileChunk chunked_file_chunk) throws Exception {
        file.position(20L);
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(++this.current_chunk_count);
        buffer.flip();
        file.write(buffer);
        file.position(32L);
        this.modification_timestamp = Instant.now().toEpochMilli();
        MemoryUtils.setLongAt(this.timestamp, this.modification_timestamp, 24);
        buffer = ByteBuffer.allocate(32);
        buffer.put(this.timestamp);
        buffer.flip();
        file.write(buffer);
        file.position(64L);
        this.setChunkPointer(chunked_file_chunk.chunk_index, chunked_file_chunk.getChunkPointer());
        this.setChunkLength(chunked_file_chunk.chunk_index, chunked_file_chunk.getChunkLength());
        buffer = ByteBuffer.allocate(this.chunk_header.length);
        buffer.put(this.chunk_header);
        buffer.flip();
        file.write(buffer);
        this.current_file_length = file.size() - (long)this.getHeaderSize();
        file.position(8L);
        buffer = ByteBuffer.allocate(8);
        buffer.putLong(this.current_file_length);
        buffer.flip();
        file.write(buffer);
    }

    public long getFileLength() {
        return this.file_length;
    }

    public int getChunkCount() {
        return this.chunk_count;
    }

    public String getFileKey() {
        return this.file_key;
    }

    public String getFileInfo() {
        return this.file_info;
    }

    private void setChunkPointer(int index, long pointer) throws Exception {
        MemoryUtils.setLongAt(this.chunk_header, pointer, index *= 12);
    }

    private void setChunkLength(int index, int length) throws Exception {
        index = index * 12 + 8;
        MemoryUtils.setIntegerAt(this.chunk_header, length, index);
    }

    public long getChunkPointer(int index) throws Exception {
        return MemoryUtils.getLongAt(this.chunk_header, index *= 12);
    }

    public int getChunkLength(int index) throws Exception {
        index = index * 12 + 8;
        return MemoryUtils.getIntegerAt(this.chunk_header, index);
    }

    public String toString(Boolean extend) {
        try {
            String chunk_missing = null;
            if (extend.booleanValue()) {
                StringBuilder string = new StringBuilder();
                int length = this.chunk_header.length / 12;
                string.append("..... Start Header Dump .....\n");
                for (int i = 0; i < length; ++i) {
                    long chunk_pointer = this.getChunkPointer(i);
                    int chunk_length = this.getChunkLength(i);
                    if (chunk_pointer == 0L || chunk_length == 0) {
                        string.append(i).append("[").append(chunk_pointer).append(",").append(chunk_length).append("], ..... error .....\n");
                        continue;
                    }
                    string.append(i).append("[").append(chunk_pointer).append(",").append(chunk_length).append("],\n");
                }
                string.append("..... End Header Dump .....\n");
                chunk_missing = string.toString();
            }
            Boolean is_complete = this.isFileLengthComplete() != false && this.isChucnkCountComplete() != false;
            return "Stats: File is " + (is_complete == true ? "complete" : "not complete") + "\nCreated: " + this.sdf.format(this.createion_timestamp) + " - Modified: " + this.sdf.format(this.modification_timestamp) + "\nfile_length: " + this.file_length + "\ncurrent_file_length: " + this.current_file_length + "\nchunk_count: " + this.chunk_count + "\ncurrent_chunk_count: " + this.current_chunk_count + "\nfile_key_bytes_size: " + this.file_key_bytes_size + "\nfile_key: " + this.file_key + "\nfile_info_bytes_size: " + this.file_info_bytes_size + "\nfile_info: " + this.file_info + (String)(is_complete == true ? "" : "\nRemaining chunk count [" + (this.chunk_count - this.current_chunk_count) + "]\n" + (String)(chunk_missing == null ? "" : chunk_missing + "\n") + "Remaining File length [" + df.format((this.file_length - this.current_file_length) / 1024L / 1024L / 1024L) + "]GB [" + df.format((this.file_length - this.current_file_length) / 1024L / 1024L % 1024L) + "]MB [" + df.format((this.file_length - this.current_file_length) / 1024L % 1024L * 1024L) + "]KB [" + df.format((this.file_length - this.current_file_length) % 0x40000000L) + "]B");
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    public String toString() {
        return this.toString(false);
    }
}

