/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.binary.file;

public class MemoryUtils {
    public static byte[] IntegerArrayToByteArray(int[] integer_array) {
        byte[] byte_array = new byte[integer_array.length * 4];
        for (int index = 0; index < integer_array.length; ++index) {
            int integer = integer_array[index];
            byte_array[index * 4] = (byte)(integer >> 24);
            byte_array[index * 4 + 1] = (byte)(integer >> 16);
            byte_array[index * 4 + 2] = (byte)(integer >> 8);
            byte_array[index * 4 + 3] = (byte)integer;
        }
        return byte_array;
    }

    public static int[] ByteArrayToIntegerArray(byte[] byte_array) throws Exception {
        if (byte_array.length % 4 != 0) {
            throw new Exception("Byte Array is not a 4 bytes integer aligned array!");
        }
        int[] integer_array = new int[byte_array.length / 4];
        for (int index = 0; index < integer_array.length; ++index) {
            int integer = 0;
            integer_array[index] = integer = (byte_array[index * 4] & 0xFF) << 24 | (byte_array[index * 4 + 1] & 0xFF) << 16 | (byte_array[index * 4 + 2] & 0xFF) << 8 | byte_array[index * 4 + 3] & 0xFF;
        }
        return integer_array;
    }

    public static void setIntegerAt(byte[] byte_array, int integer, int index) throws Exception {
        if (byte_array.length < index + 4) {
            throw new Exception("Insufficient bytes in the array to pack integer.");
        }
        byte_array[index] = (byte)(integer >> 24);
        byte_array[index + 1] = (byte)(integer >> 16);
        byte_array[index + 2] = (byte)(integer >> 8);
        byte_array[index + 3] = (byte)integer;
    }

    public static int getIntegerAt(byte[] byte_array, int index) throws Exception {
        if (byte_array.length < index + 4) {
            throw new Exception("Insufficient bytes in the array to convert to integer.");
        }
        int integer = (byte_array[index] & 0xFF) << 24 | (byte_array[index + 1] & 0xFF) << 16 | (byte_array[index + 2] & 0xFF) << 8 | byte_array[index + 3] & 0xFF;
        return integer;
    }

    public static void setLongAt(byte[] byte_array, long lonG, int index) throws Exception {
        if (byte_array.length < index + 8) {
            throw new Exception("Insufficient bytes in the array to pack long.");
        }
        byte_array[index] = (byte)(lonG >> 56);
        byte_array[index + 1] = (byte)(lonG >> 48);
        byte_array[index + 2] = (byte)(lonG >> 40);
        byte_array[index + 3] = (byte)(lonG >> 32);
        byte_array[index + 4] = (byte)(lonG >> 24);
        byte_array[index + 5] = (byte)(lonG >> 16);
        byte_array[index + 6] = (byte)(lonG >> 8);
        byte_array[index + 7] = (byte)lonG;
    }

    public static long getLongAt(byte[] byte_array, int index) throws Exception {
        if (byte_array.length < index + 8) {
            throw new Exception("Insufficient bytes in the array to convert to long.");
        }
        long lonG = ((long)byte_array[index] & 0xFFL) << 56 | ((long)byte_array[index + 1] & 0xFFL) << 48 | ((long)byte_array[index + 2] & 0xFFL) << 40 | ((long)byte_array[index + 3] & 0xFFL) << 32 | ((long)byte_array[index + 4] & 0xFFL) << 24 | ((long)byte_array[index + 5] & 0xFFL) << 16 | ((long)byte_array[index + 6] & 0xFFL) << 8 | (long)byte_array[index + 7] & 0xFFL;
        return lonG;
    }
}

