/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.data.source;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DataSourceService {
    private static DataSourceService data_source_service;
    private static List<DataSource> datasources_list;
    private static Map<String, DataSource> datasources_map;

    public DataSourceService(List<DataSource> datasources_list, Map<String, DataSource> datasources_map, DataSource default_data_source) {
        data_source_service = this;
        DataSourceService.datasources_list = datasources_list;
        DataSourceService.datasources_map = datasources_map;
        DataSourceService.datasources_map.put("default", default_data_source);
    }

    public static Connection getConnection() throws SQLException {
        DataSource data_source = datasources_map.get("default");
        if (data_source == null) {
            throw new SQLException("Default DataSource is null");
        }
        return data_source.getConnection();
    }

    public static Connection getConnection(String data_source_name) throws SQLException {
        DataSource data_source = datasources_map.get(data_source_name);
        if (data_source == null) {
            throw new SQLException("DataSource '" + data_source_name + "' is null");
        }
        return data_source.getConnection();
    }
}

