/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.environment;

import java.security.MessageDigest;
import java.util.Base64;
import net.reyadeyat.api.library.util.BooleanParser;

public abstract class ApiEnvironment {
    private static MessageDigest sha_256_md;
    private static ApiEnvironment api_environment;

    public ApiEnvironment() throws Exception {
        api_environment = this;
        sha_256_md = MessageDigest.getInstance("SHA-256");
    }

    protected abstract String _getProperty(String var1);

    public static String getProperty(String property_name) {
        return api_environment._getProperty(property_name);
    }

    protected abstract String _getString(String var1);

    public static String getString(String property_name) {
        return api_environment._getProperty(property_name);
    }

    protected abstract int _getInteger(String var1) throws Exception;

    public static int getInteger(String integer_property) throws Exception {
        return Integer.parseInt(api_environment._getProperty(integer_property));
    }

    protected abstract boolean _getBoolean(String var1) throws Exception;

    public static boolean getBoolean(String boolean_property) throws Exception {
        return BooleanParser.parse(ApiEnvironment.getProperty(boolean_property));
    }

    public static String sha256(String message) throws Exception {
        sha_256_md.update(message.getBytes("UTF-8"));
        byte[] digest = sha_256_md.digest();
        return Base64.getEncoder().encodeToString(digest);
    }
}

