/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import net.reyadeyat.api.library.http.IPRule;

public class IP {
    private static JsonObject ip_set_json;
    protected static TreeMap<String, IPRule> reject_ip_map;
    protected static TreeMap<String, IPRule> accept_ip_map;
    protected static IPRule star_rule;

    public static Boolean initialized() throws ServletException {
        return reject_ip_map != null && accept_ip_map != null;
    }

    public static void loadTomcatIP() throws ServletException {
        if (reject_ip_map != null && accept_ip_map != null) {
            return;
        }
        try {
            star_rule = null;
            InitialContext context = new InitialContext();
            String SERVER_IP_FILE = (String)context.lookup("java:comp/env/SERVER_IP_FILE");
            if (SERVER_IP_FILE == null || SERVER_IP_FILE.length() == 0) {
                Logger.getLogger(IP.class.getName()).log(Level.CONFIG, "IP file string is empty or not defined");
            } else {
                File file = new File(SERVER_IP_FILE);
                try (JsonReader reader = new JsonReader((Reader)new FileReader(file));){
                    Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create();
                    ip_set_json = (JsonObject)gson.fromJson(reader, JsonObject.class);
                }
                catch (Exception ex) {
                    throw new ServletException((Throwable)ex);
                }
            }
            reject_ip_map = new TreeMap();
            accept_ip_map = new TreeMap();
            JsonArray reject_ip_set_json = ip_set_json.get("reject").getAsJsonArray();
            for (int i = 0; i < reject_ip_set_json.size(); ++i) {
                JsonObject ip_rule = reject_ip_set_json.get(i).getAsJsonObject();
                String ip = ip_rule.get("ip").getAsString();
                String rule = ip_rule.get("rule").getAsString();
                reject_ip_map.put(ip, new IPRule(ip, rule));
            }
            JsonArray trust_ip_set_json = ip_set_json.get("accept").getAsJsonArray();
            for (int i = 0; i < trust_ip_set_json.size(); ++i) {
                JsonObject ip_rule = trust_ip_set_json.get(i).getAsJsonObject();
                String ip = ip_rule.get("ip").getAsString();
                String rule = ip_rule.get("rule").getAsString();
                accept_ip_map.put(ip, new IPRule(ip, rule));
            }
            star_rule = accept_ip_map.get("*");
        }
        catch (Exception ex) {
            reject_ip_map = null;
            accept_ip_map = null;
            Logger.getLogger(IP.class.getName()).log(Level.CONFIG, "IP File Error file context not defined in context.xml", ex);
            throw new ServletException((Throwable)ex);
        }
    }

    public static IPRule isValidIP(String ip) throws Exception {
        if (reject_ip_map != null && accept_ip_map != null) {
            IP.loadTomcatIP();
        }
        if (ip.indexOf(".") > 0) {
            IPRule tomcat_ip_rule = reject_ip_map.get(ip);
            if (tomcat_ip_rule != null) {
                return null;
            }
            String[] parts = ip.split("\\.");
            StringBuilder b = new StringBuilder();
            for (String part : parts) {
                b.append(part);
                tomcat_ip_rule = reject_ip_map.get(b.toString());
                if (tomcat_ip_rule != null) {
                    return null;
                }
                b.append(".");
            }
            tomcat_ip_rule = accept_ip_map.get(ip);
            if (tomcat_ip_rule != null) {
                return tomcat_ip_rule;
            }
            b.delete(0, b.length());
            for (String part : parts) {
                b.append(part);
                tomcat_ip_rule = accept_ip_map.get(b.toString());
                if (tomcat_ip_rule != null) {
                    return tomcat_ip_rule;
                }
                b.append(".");
            }
        } else if (ip.indexOf(":") > 0) {
            IPRule tomcat_ip_rule;
            String[] parts = ip.split(":");
            StringBuilder b = new StringBuilder();
            for (String part : parts) {
                b.append(part);
                tomcat_ip_rule = reject_ip_map.get(b.toString());
                if (tomcat_ip_rule != null) {
                    return tomcat_ip_rule;
                }
                b.append(":");
            }
            b.delete(0, b.length());
            for (String part : parts) {
                b.append(part);
                tomcat_ip_rule = accept_ip_map.get(b.toString());
                if (tomcat_ip_rule != null) {
                    return tomcat_ip_rule;
                }
                b.append(":");
            }
        }
        if (star_rule != null) {
            return star_rule;
        }
        return null;
    }
}

