/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import java.net.URI;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.net.ssl.HttpsURLConnection;
import net.reyadeyat.api.library.http.Connect;
import net.reyadeyat.api.library.http.RequestCookies;
import net.reyadeyat.api.library.http.RequestHeaders;
import net.reyadeyat.api.library.http.RequestPayload;
import net.reyadeyat.api.library.http.Response;
import net.reyadeyat.api.library.http.SessionManager;

public abstract class Request {
    METHOD method;
    CONTENT_TYPE content_type;
    URL url;
    int connection_time_out;
    boolean force_trust_url;
    String content;
    boolean follow_redirects;
    SessionManager session_manager;
    RequestHeaders request_headers;
    RequestPayload request_payload;
    RequestCookies request_cookies;
    boolean log_errors;

    public Request(METHOD method, CONTENT_TYPE content_type, String url, int connection_time_out, boolean force_trust_url, RequestPayload request_payload, boolean follow_redirects, RequestHeaders request_headers, RequestCookies request_cookies, SessionManager session_manager, boolean log_errors) throws Exception {
        this.method = method;
        this.content_type = content_type;
        this.url = new URI(url).toURL();
        this.connection_time_out = connection_time_out;
        this.force_trust_url = force_trust_url;
        this.follow_redirects = follow_redirects;
        this.request_cookies = request_cookies;
        this.session_manager = session_manager;
        this.log_errors = log_errors;
        this.request_headers = request_headers;
    }

    public void connect() {
        this.connect(false);
    }

    public FutureTask connect(boolean asynchronized) {
        if (asynchronized) {
            final Request request = this;
            FutureTask<Response> future_task = new FutureTask<Response>(new Callable<Response>(){
                final /* synthetic */ Request this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Response call() throws Exception {
                    Response response = null;
                    try {
                        response = Connect.connect(request);
                        this.this$0.connectionSuccess(response);
                        return response;
                    }
                    catch (Exception exception) {
                        this.this$0.connectionFailure(exception);
                        return response;
                    }
                }
            });
            return future_task;
        }
        Response response = null;
        try {
            response = Connect.connect(this);
            this.connectionSuccess(response);
        }
        catch (Exception exception) {
            this.connectionFailure(exception);
        }
        return null;
    }

    public abstract void connectionSuccess(Response var1);

    public abstract void connectionFailure(Exception var1);

    void manageConnection(HttpsURLConnection connection) throws Exception {
        connection.setRequestMethod(this.method.toString());
        if (this.request_headers != null) {
            this.request_headers.manageConnection(connection);
        }
        if (this.request_cookies != null) {
            this.request_cookies.manageConnection(connection);
        }
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(this.follow_redirects);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setConnectTimeout(this.connection_time_out);
        connection.setReadTimeout(this.connection_time_out);
    }

    public StringBuilder getRequestHeadersLog() {
        return this.request_headers == null ? new StringBuilder() : this.request_headers.get_request_headers_log();
    }

    public StringBuilder getPayloadLog() {
        return this.request_payload == null ? new StringBuilder() : this.request_payload.get_payload_log();
    }

    public static enum METHOD {
        GET("GET"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        HEAD("HEAD"),
        TRACE("TRACE"),
        PATCH("PATCH");

        private final String method;

        private METHOD(String method) {
            this.method = method;
        }

        public String toString() {
            return this.method;
        }
    }

    public static enum CONTENT_TYPE {
        FORM_DATA("multipart/form-data"),
        FORM_URL_ENCODED("application/x-www-form-urlencoded"),
        APPLICATION_TEXT("application/text"),
        APPLICATION_JSON("application/json"),
        APPLICATION_XML("application/xml"),
        TEXT_PLAIN("text/plain"),
        TEXT_HTML("text/html"),
        TEXT_CSS("text/css"),
        APPLICATION_OCTET_STREAM("application/octet-stream"),
        APPLICATION_JAVASCRIPT("application/javascript"),
        APPLICATION_PDF("application/pdf"),
        IMAGE_JPEG("image/jpeg"),
        IMAGE_PNG("image/png"),
        IMAGE_BMP("image/bmp"),
        IMAGE_GIF("image/gif"),
        IMAGE_SVG("image/svg+xml"),
        VIDEO_MP4("video/mp4"),
        MS_DOC("application/msword"),
        MS_DOCX("application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
        MS_EXCEL("application/vnd.ms-excel"),
        MS_XLS("application/vnd.ms-excel"),
        MS_EXCELX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
        MS_XLSX("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
        MS_POWR_POINT("application/vnd.ms-powerpoint"),
        MS_PPT("application/vnd.ms-powerpoint"),
        MS_POWR_POINTX("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
        MS_PPTX("application/vnd.openxmlformats-officedocument.presentationml.presentation"),
        LIBRE_OFFICE_ODT("application/vnd.oasis.opendocument.text"),
        LIBRE_OFFICE_ODS("application/vnd.oasis.opendocument.spreadsheet"),
        LIBRE_OFFICE_ODP("application/vnd.oasis.opendocument.presentation");

        private final String content_type;

        private CONTENT_TYPE(String content_type) {
            this.content_type = content_type;
        }

        public String toString() {
            return this.content_type;
        }
    }
}

