/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import net.reyadeyat.api.library.http.Cookie;

public class RequestCookies {
    List<Cookie> cookies;

    public RequestCookies() {
        this(new ArrayList<Cookie>());
    }

    public RequestCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void manageConnection(HttpsURLConnection connection) {
        StringBuilder cookies_build = new StringBuilder();
        for (Cookie cookie : this.cookies) {
            cookies_build.append(cookie.cookie_name).append("=").append(cookie.cookie_value).append(";");
            if (cookie.path != null && !cookie.path.isBlank()) {
                cookies_build.append("Path=").append(cookie.path).append(";");
                continue;
            }
            if (cookie.secure.booleanValue()) {
                cookies_build.append("Secure;");
                continue;
            }
            if (cookie.http_only.booleanValue()) {
                cookies_build.append("HttpOnly;");
                continue;
            }
            if (cookie.same_site == null || cookie.same_site.isBlank()) continue;
            cookies_build.append("SameSite=").append(cookie.same_site).append(";");
        }
        connection.setRequestProperty("Cookie", cookies_build.toString());
    }
}

