/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class RequestHeaders {
    Map<String, List<String>> request_headers_map = new HashMap<String, List<String>>();
    StringBuilder request_headers_log = new StringBuilder();
    boolean log_request_headers;
    boolean log_response_headers;

    public RequestHeaders() {
        this(true, "anonymous", false, false);
    }

    public RequestHeaders(boolean is_api, String user_agent, boolean log_request_headers, boolean log_response_headers) {
        this.log_request_headers = log_request_headers;
        this.log_response_headers = log_response_headers;
        if (is_api) {
            this.request_headers_map.put("User-Agent", new ArrayList<String>(Arrays.asList(user_agent)));
            this.request_headers_map.put("Accept-Charset", new ArrayList<String>(Arrays.asList("UTF-8")));
            this.request_headers_map.put("Cache-Control", new ArrayList<String>(Arrays.asList("no-cache")));
            this.request_headers_map.put("Connection", new ArrayList<String>(Arrays.asList("Keep-Alive")));
            this.request_headers_map.put("Accept-Encoding", new ArrayList<String>(Arrays.asList("gzip, deflate")));
        }
    }

    public void addHeader(String header, String value) {
        if (!this.request_headers_map.containsKey(header)) {
            this.request_headers_map.put(header, new ArrayList());
        }
        this.request_headers_map.get(header).add(value);
    }

    public void setHeader(String header, String value) {
        if (this.request_headers_map.containsKey(header)) {
            this.request_headers_map.get(header).clear();
            this.request_headers_map.get(header).add(value);
            return;
        }
        this.addHeader(header, value);
    }

    StringBuilder manageConnection(HttpsURLConnection connection) {
        for (Map.Entry<String, List<String>> header_entry : this.request_headers_map.entrySet()) {
            String header_name = header_entry.getKey();
            List<String> header_list = header_entry.getValue();
            for (String header : header_list) {
                connection.addRequestProperty(header_name, header);
                if (!this.log_request_headers) continue;
                this.request_headers_log.append(header_entry).append(": ").append(header).append("\n");
            }
        }
        return this.request_headers_log;
    }

    public StringBuilder get_request_headers_log() {
        return this.request_headers_log;
    }
}

