/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import java.util.List;
import java.util.TreeMap;
import net.reyadeyat.api.library.http.Cookie;

public class ResponseCookies {
    public List<String> raw_cookie_list;
    public TreeMap<String, Cookie> cookie_map = new TreeMap();

    public ResponseCookies(List<String> raw_cookie_list) {
        if (raw_cookie_list == null) {
            return;
        }
        this.raw_cookie_list = raw_cookie_list;
        for (String raw_cookie : this.raw_cookie_list) {
            String[] cookie_parts = raw_cookie.split(";");
            String[] nameValue = cookie_parts[0].split("=");
            String cookie_name = nameValue[0].trim();
            String cookie_value = nameValue[1].trim();
            String path = "/";
            boolean secure = false;
            boolean http_only = false;
            String same_site = "Lax";
            for (int i = 1; i < cookie_parts.length; ++i) {
                String part = cookie_parts[i].trim();
                if (part.equalsIgnoreCase("Secure")) {
                    secure = true;
                    continue;
                }
                if (part.equalsIgnoreCase("HttpOnly")) {
                    http_only = true;
                    continue;
                }
                if (part.startsWith("Path=")) {
                    path = part.substring(5);
                    continue;
                }
                if (!part.startsWith("SameSite=")) continue;
                same_site = part.substring(9);
            }
            Cookie cookie = new Cookie(cookie_name, cookie_value, path, secure, http_only, same_site);
            this.cookie_map.put(cookie_name, cookie);
        }
    }
}

