/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class ResponseHeaders {
    Map<String, List<String>> response_header_map = new HashMap<String, List<String>>();
    StringBuilder response_headers_log = new StringBuilder();

    public ResponseHeaders(boolean log_response_headers) {
    }

    public void addHeader(String header, String value) {
        if (!this.response_header_map.containsKey(header)) {
            this.response_header_map.put(header, new ArrayList());
        }
        this.response_header_map.get(header).add(value);
    }

    public void setHeader(String header, String value) {
        if (this.response_header_map.containsKey(header)) {
            this.response_header_map.get(header).clear();
            this.response_header_map.get(header).add(value);
            return;
        }
        this.addHeader(header, value);
    }

    StringBuilder manageConnection(HttpsURLConnection connection, boolean log_request_headers) {
        for (Map.Entry<String, List<String>> header_entry : this.response_header_map.entrySet()) {
            String header_name = header_entry.getKey();
            List<String> header_list = header_entry.getValue();
            for (String header : header_list) {
                connection.addRequestProperty(header_name, header);
                if (!log_request_headers) continue;
                this.response_headers_log.append(header_entry).append(": ").append(header).append("\n");
            }
        }
        return this.response_headers_log;
    }

    public StringBuilder get_response_headers_log() {
        return this.response_headers_log;
    }
}

