/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import jakarta.servlet.ServletException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.reyadeyat.api.library.http.HostCertificate;

public class TLS {
    private static final Object load_lock = new Object();
    private static SSLSocketFactory ssf;
    private static SSLSocketFactory untrusted_ssf;
    private static KeyStore key_store;
    private static final char[] base_password;
    private static CertificateFactory certificate_factory;
    private static KeyPairGenerator generator;
    private static final TreeMap<String, HostCertificate> cached_host_map;
    private static final String protocol = "TLSv1.3";

    public static Boolean initialized() throws ServletException {
        return ssf != null;
    }

    public static SSLSocketFactory getSocketFactory() throws Exception {
        if (ssf != null) {
            return ssf;
        }
        throw new Exception("SecureSocketFactory is null");
    }

    public static SSLSocketFactory loadSocketFactory(String SERVER_TLS_FILE) throws Exception {
        Object object = load_lock;
        synchronized (object) {
            try {
                String alias;
                if (certificate_factory == null) {
                    certificate_factory = CertificateFactory.getInstance("X.509");
                }
                if (generator == null) {
                    generator = KeyPairGenerator.getInstance("RSA");
                    generator.initialize(2048, new SecureRandom());
                }
                JsonArray tls_config = null;
                InitialContext context = new InitialContext();
                if (SERVER_TLS_FILE == null || SERVER_TLS_FILE.length() == 0) {
                    Logger.getLogger(TLS.class.getName()).log(Level.CONFIG, "TLS file string is empty or not defined");
                } else {
                    File file = new File(SERVER_TLS_FILE);
                    try (JsonReader reader = new JsonReader((Reader)new FileReader(file));){
                        Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create();
                        tls_config = (JsonArray)gson.fromJson(reader, JsonArray.class);
                    }
                    catch (Exception ex) {
                        throw new ServletException((Throwable)ex);
                    }
                }
                try {
                    key_store = KeyStore.getInstance(KeyStore.getDefaultType());
                    key_store.load(new FileInputStream(new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts")), base_password);
                }
                catch (Exception ex) {
                    Logger.getLogger(TLS.class.getName()).log(Level.CONFIG, "Error: loading JDK default TLS File '" + System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + " cacerts password 'changeit', you need to provid correct settings in tomcat.tls.properties with correct path and password", ex);
                    key_store.load(null, base_password);
                }
                for (int i = 0; i < tls_config.size(); ++i) {
                    Object ssf;
                    String cert_protocol;
                    String name;
                    JsonObject json = tls_config.get(i).getAsJsonObject();
                    String format = json.get("format").getAsString();
                    if (format.equalsIgnoreCase("jks")) {
                        name = json.get("name").getAsString();
                        String key_store_name = json.get("keystore").getAsString();
                        String path = json.get("path").getAsString();
                        alias = json.get("alias").getAsString();
                        String passwordz = json.get("password").getAsString();
                        cert_protocol = json.get("protocol").getAsString();
                        ssf = null;
                        if (passwordz == null || passwordz.isBlank()) {
                            throw new Exception("jks password is blank");
                        }
                        char[] password = passwordz.toCharArray();
                        try (FileInputStream trustStream = new FileInputStream(path);){
                            KeyStore key_store_x = KeyStore.getInstance(KeyStore.getDefaultType());
                            key_store_x.load(trustStream, password);
                            Key key = key_store_x.getKey(alias, password);
                            key_store.setKeyEntry(alias, key, base_password, key_store_x.getCertificateChain(alias));
                            continue;
                        }
                        catch (Exception ex) {
                            Logger.getLogger(TLS.class.getName()).log(Level.SEVERE, "TLS File '" + name + "' Error", ex);
                            throw ex;
                        }
                    }
                    if (!format.equalsIgnoreCase("cert")) continue;
                    name = json.get("name").getAsString();
                    String alias2 = json.get("alias").getAsString();
                    String password = json.get("password").getAsString();
                    String key_store_name = json.get("keystore").getAsString();
                    String path = json.get("path").getAsString();
                    cert_protocol = json.get("protocol").getAsString();
                    ssf = null;
                    try (FileInputStream fis = new FileInputStream(path);){
                        X509Certificate ca = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new BufferedInputStream(fis));
                        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
                        generator.initialize(2048, new SecureRandom());
                        KeyPair key_pair = generator.generateKeyPair();
                        Certificate[] certificateChain = new Certificate[]{ca};
                        key_store.setKeyEntry(alias2, key_pair.getPrivate(), base_password, certificateChain);
                        continue;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(TLS.class.getName()).log(Level.SEVERE, "TLS File '" + name + "' Error", ex);
                        throw ex;
                    }
                }
                String protocol = protocol;
                TrustManagerFactory trust_factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trust_factory.init(key_store);
                KeyManagerFactory key_manager_factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                key_manager_factory.init(key_store, base_password);
                SSLContext sc = SSLContext.getInstance(protocol);
                sc.init(key_manager_factory.getKeyManagers(), trust_factory.getTrustManagers(), new SecureRandom());
                ssf = sc.getSocketFactory();
                try {
                    StringBuilder b = new StringBuilder("TLS Loaded Aliases list\n");
                    Enumeration<String> aliases = key_store.aliases();
                    while (aliases.hasMoreElements()) {
                        alias = aliases.nextElement();
                        b.append("  alisa: ").append(alias).append("\n");
                        Certificate[] certificates = key_store.getCertificateChain(alias);
                        if (certificates == null || certificates.length == 0) {
                            b.append("    certificate: ").append(certificates == null ? "null" : "0").append("\n");
                            continue;
                        }
                        for (Certificate certificate : certificates) {
                            b.append("    certificate: ").append(certificate == null ? "null" : certificate.toString()).append("\n");
                        }
                    }
                    Logger.getLogger(TLS.class.getName()).log(Level.FINE, b.toString());
                    return ssf;
                }
                catch (Exception ex) {
                    ssf = null;
                    throw ex;
                }
            }
            catch (Exception ex) {
                ssf = null;
                Logger.getLogger(TLS.class.getName()).log(Level.SEVERE, "TLS File Error file context is not defined in context.xml", ex);
                throw ex;
            }
        }
    }

    private static void createUntrustedManager() throws Exception {
        if (untrusted_ssf != null) {
            return;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        untrusted_ssf = sslContext.getSocketFactory();
    }

    private static void getServerCertificates(URL connection_url) throws Exception {
        TLS.getServerCertificates(connection_url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getServerCertificates(URL connection_url, Boolean update_certificate) throws Exception {
        String host = connection_url.getHost();
        TreeMap<String, HostCertificate> treeMap = cached_host_map;
        synchronized (treeMap) {
            if (!update_certificate.booleanValue() && cached_host_map.containsKey(host)) {
                return;
            }
            HttpsURLConnection https_url_connection = (HttpsURLConnection)connection_url.openConnection();
            https_url_connection.setSSLSocketFactory(untrusted_ssf);
            KeyPair key_pair = generator.generateKeyPair();
            https_url_connection.connect();
            Certificate[] certificate_chain = https_url_connection.getServerCertificates();
            key_store.setKeyEntry(host, key_pair.getPrivate(), base_password, certificate_chain);
            HostCertificate host_certificate = new HostCertificate();
            host_certificate.host = host;
            host_certificate.certificate_chain = certificate_chain;
            TrustManagerFactory trust_factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trust_factory.init(key_store);
            KeyManagerFactory key_manager_factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            key_manager_factory.init(key_store, base_password);
            SSLContext sc = SSLContext.getInstance(protocol);
            sc.init(key_manager_factory.getKeyManagers(), trust_factory.getTrustManagers(), new SecureRandom());
            ssf = sc.getSocketFactory();
            cached_host_map.put(host, host_certificate);
        }
    }

    public static HttpsURLConnection getHttpsConnection(URL connection_url, Boolean force_trust_url) throws Exception {
        if (!force_trust_url.booleanValue()) {
            TLS.getServerCertificates(connection_url);
        }
        HttpsURLConnection https_url_connection = (HttpsURLConnection)connection_url.openConnection();
        https_url_connection.setSSLSocketFactory(ssf);
        return https_url_connection;
    }

    public static HttpsURLConnection getTrustedHttpsConnection(URL connection_url) throws Exception {
        return TLS.getHttpsConnection(connection_url, true);
    }

    public static HttpsURLConnection getUntrustedHttpsConnection(URL connection_url) throws Exception {
        return TLS.getHttpsConnection(connection_url, false);
    }

    public static InputStream getTrustedHttpsConnectionInputStream(URL connection_url) throws Exception {
        return TLS.getHttpsConnectionInputStream(connection_url, true);
    }

    public static InputStream getUntrustedHttpsConnectionInputStream(URL connection_url) throws Exception {
        return TLS.getHttpsConnectionInputStream(connection_url, false);
    }

    public static InputStream getHttpsConnectionInputStream(URL connection_url, Boolean force_trust_url) throws Exception {
        try {
            TLS.getServerCertificates(connection_url, false);
            HttpsURLConnection https_url_connection = (HttpsURLConnection)connection_url.openConnection();
            https_url_connection.setSSLSocketFactory(ssf);
            return https_url_connection.getInputStream();
        }
        catch (SSLHandshakeException ex) {
            if (!force_trust_url.booleanValue()) {
                TLS.getServerCertificates(connection_url, true);
                return TLS.getHttpsConnectionInputStream(connection_url, force_trust_url);
            }
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static String decrypt_parameter(String encrypted_text, byte[] encryption_key, byte[] iv_spec) throws Exception {
        return TLS.decrypt_text(URLDecoder.decode(encrypted_text, StandardCharsets.UTF_8), encryption_key, iv_spec);
    }

    public static String decrypt_text(String encrypted_text, byte[] encryption_key, byte[] iv_spec) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(iv_spec);
        if (encryption_key.length % 16 != 0) {
            throw new Exception("encryption_key " + encryption_key.length + " % 16 = " + encryption_key.length % 16);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(encryption_key, "AES");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)skeySpec, iv);
        byte[] encrypted_text_base64_bytes = Base64.getDecoder().decode(encrypted_text);
        if (encrypted_text_base64_bytes.length % 16 != 0) {
            throw new Exception("encrypted_text_base64_bytes " + encrypted_text_base64_bytes.length + " % 16 = " + encrypted_text_base64_bytes.length % 16);
        }
        byte[] plain_text_bytes = cipher.doFinal();
        String plain_text = new String(plain_text_bytes);
        return plain_text;
    }

    public static String generateRandomKey(int length) {
        String possibleDigits = TLS.shuffle(TLS.standardKey());
        StringBuilder randomNumber = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(possibleDigits.length());
            char randomChar = possibleDigits.charAt(randomIndex);
            randomNumber.append(randomChar);
        }
        return randomNumber.toString();
    }

    public static String shuffle(String content) {
        StringBuilder string = new StringBuilder(content);
        Random random = new Random();
        for (int i = string.length() - 1; i > 0; --i) {
            int randomIndex = random.nextInt(string.length() - 1);
            char temp = string.charAt(i);
            string.setCharAt(i, string.charAt(randomIndex));
            string.setCharAt(randomIndex, temp);
        }
        return string.toString();
    }

    public static String encryptKey(Integer method_id, String key, String vi) {
        Logger.getLogger(TLS.class.getName()).log(Level.INFO, "key: " + key);
        Logger.getLogger(TLS.class.getName()).log(Level.INFO, "vi: " + vi);
        StringBuilder method_key = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            StringBuilder word = new StringBuilder("" + key.charAt(i) * vi.charAt(i));
            while (word.length() < 5) {
                word.insert(0, "0");
            }
            if (i % 2 == 0) {
                word.append((int)key.charAt(i));
            } else {
                word.append((int)vi.charAt(i));
            }
            while (word.length() < 8) {
                word.insert(5, "0");
            }
            method_key.append((CharSequence)word);
        }
        TLS.replaceZeros(method_key, TLS.shuffle(TLS.randomKey()));
        return method_key.toString();
    }

    public static void decryptKey(Integer method_id, String method_key, StringBuilder key, StringBuilder vi) {
        StringBuilder m_key = new StringBuilder(method_key);
        TLS.replaceLetters(m_key);
        method_key = m_key.toString();
        for (int i = 0; i < 128; i += 8) {
            Integer low = Integer.valueOf(method_key.substring(i, i + 5));
            Integer hight = Integer.valueOf(method_key.substring(i + 5, i + 8));
            if (i / 8 % 2 == 0) {
                key.append((char)hight.intValue());
                vi.append((char)(low / hight));
                continue;
            }
            vi.append((char)hight.intValue());
            key.append((char)(low / hight));
        }
    }

    public static void replaceZeros(StringBuilder input_string, String finite_string) {
        Random random = new Random();
        for (int i = 0; i < input_string.length(); ++i) {
            if (input_string.charAt(i) != '0') continue;
            char random_char = finite_string.charAt(random.nextInt(finite_string.length()));
            input_string.replace(i, i + 1, "" + random_char);
        }
    }

    public static void replaceLetters(StringBuilder input_string) {
        for (int i = 0; i < input_string.length(); ++i) {
            if (input_string.charAt(i) < ':') continue;
            input_string.replace(i, i + 1, "0");
        }
    }

    public static String randomKey() {
        int i;
        StringBuilder qw = new StringBuilder();
        for (i = 65; i <= 90; ++i) {
            qw.append((char)i);
        }
        for (i = 97; i <= 122; ++i) {
            qw.append((char)i);
        }
        return qw.toString();
    }

    public static String standardKey() {
        int i;
        StringBuilder wq = new StringBuilder();
        for (i = 65; i <= 90; ++i) {
            wq.append((char)i);
        }
        for (i = 97; i <= 122; ++i) {
            wq.append((char)i);
        }
        for (i = 48; i <= 57; ++i) {
            wq.append((char)i);
        }
        return wq.toString();
    }

    static {
        base_password = "changeit".toCharArray();
        cached_host_map = new TreeMap();
    }
}

