/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;

public class JsonDirectElementWriter {
    public JsonWriter writer;
    public Gson gson;

    public JsonDirectElementWriter(Gson gson, JsonWriter writer) {
        this.writer = writer;
        this.gson = gson;
    }

    public void writeJsonElement(JsonElement json_element) throws Exception {
        this.gson.toJson(json_element, this.writer);
    }

    public void mergeJsonPrimitive(JsonPrimitive json_primitive) throws Exception {
        this.mergeJsonPrimitive(null, json_primitive);
    }

    public void mergeJsonPrimitive(String name, JsonPrimitive json_primitive) throws Exception {
        if (name != null) {
            this.name(name);
        }
        if (json_primitive.isBoolean()) {
            this.writer.value(json_primitive.getAsBoolean());
        } else if (json_primitive.isString()) {
            this.writer.value(json_primitive.getAsString());
        } else if (json_primitive.isNumber()) {
            this.writer.value(json_primitive.getAsNumber());
        }
    }

    public void writeJsonElement(String name, JsonElement json_element) throws Exception {
        this.name(name);
        this.gson.toJson(json_element, this.writer);
    }

    public void beginObject() throws Exception {
        this.writer.beginObject();
    }

    public void name(String name) throws Exception {
        this.writer.name(name);
    }

    public void beginArray() throws Exception {
        this.writer.beginArray();
    }

    public void endArray() throws Exception {
        this.writer.endArray();
    }

    public void endObject() throws Exception {
        this.writer.endObject();
    }

    public void nullValue() throws Exception {
        this.nullValue(null);
    }

    public void nullValue(String name) throws Exception {
        if (name != null) {
            this.name(name);
        }
        this.writer.nullValue();
    }

    public void value(Boolean value) throws Exception {
        this.writer.value(value);
    }

    public void value(Number value) throws Exception {
        this.writer.value(value);
    }

    public void value(String value) throws Exception {
        this.writer.value(value);
    }

    public void value(boolean value) throws Exception {
        this.writer.value(value);
    }

    public void value(double value) throws Exception {
        this.writer.value(value);
    }

    public void value(float value) throws Exception {
        this.writer.value(value);
    }

    public void value(long value) throws Exception {
        this.writer.value(value);
    }

    public void flush() throws Exception {
        this.writer.flush();
    }
}

