/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.reyadeyat.api.library.json.JsonUtil;
import net.reyadeyat.api.library.util.BooleanParser;

public class JsonResultset {
    public static JsonObject resultsetJson(String[] field_list, ResultSet resultset, JsonObject json) throws Exception {
        JsonArray json_resultset = JsonResultset.resultset(resultset);
        if (json == null) {
            json = new JsonObject();
        }
        JsonElement[] fields_group = new JsonElement[field_list.length];
        JsonElement[] fields_group_parent = new JsonElement[field_list.length];
        for (int c = 0; c < fields_group_parent.length; ++c) {
            fields_group[c] = new JsonObject();
        }
        JsonArray leaf = null;
        for (int c = 0; c < json_resultset.size(); ++c) {
            JsonObject record = json_resultset.get(c).getAsJsonObject();
            for (int f = 0; f < field_list.length; ++f) {
                if (record.get(field_list[f]).equals(fields_group[f])) continue;
                fields_group[f] = record.get(field_list[f]);
                if (f < field_list.length - 1) {
                    fields_group_parent[f] = new JsonObject();
                } else {
                    leaf = new JsonArray();
                    fields_group_parent[f] = leaf;
                }
                if (f > 0) {
                    ((JsonObject)fields_group_parent[f - 1]).add(record.get(field_list[f]).getAsString(), fields_group_parent[f]);
                    continue;
                }
                if (f != 0) continue;
                json.add(record.get(field_list[f]).getAsString(), fields_group_parent[f]);
            }
            leaf.add((JsonElement)record);
        }
        return json;
    }

    public static <T> void resultset(ResultSet resultset, Class<T> java_class, ArrayList<T> t_list) throws Exception {
        JsonArray json_resultset = JsonResultset.resultset(resultset);
        Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        for (int c = 0; c < json_resultset.size(); ++c) {
            Object record = gson.fromJson(json_resultset.get(c), java_class);
            t_list.add(record);
        }
    }

    public static <T> ArrayList<T> resultset(ResultSet resultset, Class<T> java_class) throws Exception {
        JsonArray json_resultset = JsonResultset.resultset(resultset);
        ArrayList<Object> t = new ArrayList<Object>(json_resultset.size());
        Gson gson = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        for (int c = 0; c < json_resultset.size(); ++c) {
            Object record = gson.fromJson(json_resultset.get(c), java_class);
            t.add(record);
        }
        return t;
    }

    public static <K, V> Map<K, V> resultsetMap(Map<K, V> map, String key, ResultSet resultset, Class<V> java_class) throws Exception {
        Gson gson = JsonUtil.gson();
        try {
            ResultSetMetaData resultset_metadata = resultset.getMetaData();
            while (resultset.next()) {
                JsonObject record = new JsonObject();
                Object key_value = resultset.getObject(key);
                for (int c = 1; c <= resultset_metadata.getColumnCount(); ++c) {
                    int field_type = resultset_metadata.getColumnType(c);
                    String field_label = resultset_metadata.getColumnLabel(c);
                    Object field_value = resultset.getObject(c);
                    JsonResultset.addRecordField(field_type, field_label, field_value, record);
                }
                V java_object = JsonUtil.jsonElementToObject((JsonElement)record, java_class);
                map.put(key_value, java_object);
            }
            JsonUtil.reclaimGson(gson);
        }
        catch (Exception ex) {
            JsonUtil.reclaimGson(gson);
            throw ex;
        }
        return map;
    }

    public static JsonArray resultset(ResultSet resultset) throws Exception {
        JsonArray json_resultset = new JsonArray();
        ResultSetMetaData resultset_metadata = resultset.getMetaData();
        int count = resultset_metadata.getColumnCount();
        while (resultset.next()) {
            JsonObject record = new JsonObject();
            json_resultset.add((JsonElement)record);
            for (int c = 1; c <= count; ++c) {
                int field_type = resultset_metadata.getColumnType(c);
                String field_label = resultset_metadata.getColumnLabel(c);
                Object field_value = resultset.getObject(c);
                JsonResultset.addRecordField(field_type, field_label, field_value, record);
            }
        }
        return json_resultset;
    }

    public static void jsonElementStreaming(JsonElement json_element, JsonWriter json_writer) throws Exception {
        JsonResultset.jsonElementStreaming(null, json_element, json_writer);
    }

    public static void jsonElementStreaming(String json_property_name, JsonElement json_element, JsonWriter json_writer) throws Exception {
        if (json_element.isJsonObject()) {
            JsonObject json_object = json_element.getAsJsonObject();
            if (json_property_name != null) {
                json_writer.name(json_property_name);
            }
            json_writer.beginObject();
            Set entrySet = json_object.entrySet();
            for (Map.Entry entry : entrySet) {
                String json_element_name = (String)entry.getKey();
                JsonElement json_element_value = (JsonElement)entry.getValue();
                if (json_element_value.isJsonNull()) {
                    json_writer.name(json_element_name).value((String)null);
                    continue;
                }
                if (json_element_value.isJsonPrimitive()) {
                    JsonPrimitive json_primitive = json_element_value.getAsJsonPrimitive();
                    if (json_primitive.isString()) {
                        json_writer.name(json_element_name).value(json_primitive.getAsString());
                        continue;
                    }
                    if (json_primitive.isNumber()) {
                        json_writer.name(json_element_name).value(json_primitive.getAsNumber());
                        continue;
                    }
                    if (!json_primitive.isBoolean()) continue;
                    json_writer.name(json_element_name).value(json_primitive.getAsBoolean());
                    continue;
                }
                if (json_element_value.isJsonArray() || json_element_value.isJsonObject()) {
                    JsonResultset.jsonElementStreaming(json_element_name, json_element_value, json_writer);
                    continue;
                }
                throw new Exception("jsonObjectStreaming undefined Json structure");
            }
            json_writer.endObject();
        } else if (json_element.isJsonArray()) {
            JsonArray json_array = json_element.getAsJsonArray();
            if (json_property_name == null) {
                json_writer.name(json_property_name);
            }
            json_writer.beginArray();
            for (int i = 0; i < json_array.size(); ++i) {
                JsonElement json_element_value = json_array.get(i);
                if (json_element_value.isJsonNull()) {
                    json_writer.value((String)null);
                    continue;
                }
                if (json_element_value.isJsonPrimitive()) {
                    JsonPrimitive json_primitive = json_element_value.getAsJsonPrimitive();
                    if (json_primitive.isString()) {
                        json_writer.value(json_primitive.getAsString());
                        continue;
                    }
                    if (json_primitive.isNumber()) {
                        json_writer.value(json_primitive.getAsNumber());
                        continue;
                    }
                    if (!json_primitive.isBoolean()) continue;
                    json_writer.value(json_primitive.getAsBoolean());
                    continue;
                }
                if (json_element_value.isJsonArray() || json_element_value.isJsonObject()) {
                    JsonResultset.jsonElementStreaming(json_element_value, json_writer);
                    continue;
                }
                throw new Exception("jsonObjectStreaming undefined Json structure");
            }
            json_writer.endArray();
        } else {
            throw new Exception("jsonObjectStreaming undefined Json seymantic");
        }
    }

    public static void resultsetStreaming(JsonObject response, Writer writer, ResultSet jdbc_resultset) throws Exception {
        Gson gson = JsonUtil.gson();
        try (JsonWriter json_writer = new JsonWriter(writer);){
            json_writer.beginObject();
            JsonResultset.jsonElementStreaming("response", (JsonElement)response, json_writer);
            json_writer.name("resultset");
            json_writer.beginArray();
            ResultSetMetaData resultset_metadata = jdbc_resultset.getMetaData();
            int count = resultset_metadata.getColumnCount();
            while (jdbc_resultset.next()) {
                JsonObject record = new JsonObject();
                for (int c = 1; c <= count; ++c) {
                    int field_type = resultset_metadata.getColumnType(c);
                    String field_label = resultset_metadata.getColumnLabel(c);
                    Object field_value = jdbc_resultset.getObject(c);
                    JsonResultset.addRecordField(field_type, field_label, field_value, record);
                }
                gson.toJson((Object)record, JsonObject.class, json_writer);
            }
            json_writer.endArray();
            json_writer.endObject();
        }
    }

    public static JsonObject resultsetCompact(ResultSet resultset) throws Exception {
        JsonObject json_result = new JsonObject();
        ResultSetMetaData resultset_metadata = resultset.getMetaData();
        int count = resultset_metadata.getColumnCount();
        JsonArray header = new JsonArray();
        json_result.add("header", (JsonElement)header);
        for (int c = 1; c <= count; ++c) {
            int field_type = resultset_metadata.getColumnType(c);
            String field_label = resultset_metadata.getColumnLabel(c);
            JsonObject field = new JsonObject();
            header.add((JsonElement)field);
            field.addProperty("label", field_label);
            field.addProperty("type", JsonResultset.getFieldType(field_type));
        }
        JsonArray json_resultset = new JsonArray();
        json_result.add("resultset", (JsonElement)json_resultset);
        while (resultset.next()) {
            JsonArray record = new JsonArray();
            json_resultset.add((JsonElement)record);
            for (int c = 1; c <= count; ++c) {
                int field_type = resultset_metadata.getColumnType(c);
                Object field_value = resultset.getObject(c);
                JsonResultset.putField(field_type, field_value, record);
            }
        }
        return json_result;
    }

    public static String getFieldType(int field_type) throws Exception {
        switch (field_type) {
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return "string";
            }
            case -7: 
            case -6: 
            case 16: {
                return "boolean";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "number";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 2014: {
                return "TIMESTAMP_WITH_TIMEZONE";
            }
            case 2013: {
                return "TIME_WITH_TIMEZONE";
            }
        }
        throw new Exception("Ubndefined SQL field java.sql.Types '" + field_type + "'");
    }

    public static void putField(int field_type, Object field_value, JsonArray record) throws Exception {
        if (field_value == null) {
            record.add((JsonElement)JsonNull.INSTANCE);
            return;
        }
        switch (field_type) {
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                record.add((String)field_value);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                record.add(BooleanParser.parse(field_value.toString()));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                record.add((Number)field_value);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                record.add(field_value.toString());
                break;
            }
            default: {
                throw new Exception("Ubndefined SQL field java.sql.Types '" + field_type + "'");
            }
        }
    }

    public static void addRecordField(int field_type, String field_label, Object field_value, JsonObject record) throws Exception {
        if (field_value == null) {
            record.add(field_label, (JsonElement)JsonNull.INSTANCE);
            return;
        }
        switch (field_type) {
            case -16: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                record.addProperty(field_label, (String)field_value);
                break;
            }
            case -7: 
            case -6: 
            case 16: {
                record.addProperty(field_label, BooleanParser.parse(field_value.toString()));
                break;
            }
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                record.addProperty(field_label, (Number)field_value);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                record.addProperty(field_label, field_value.toString());
                break;
            }
            default: {
                throw new Exception("Ubndefined SQL field field_label '" + field_label + "' java.sql.Types '" + field_type + "'");
            }
        }
    }
}

