/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class JsonStringAdapter
extends TypeAdapter<String> {
    public void write(JsonWriter out, String value) throws IOException {
        out.value(value);
    }

    public String read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        StringBuilder b = new StringBuilder();
        if (token == JsonToken.BEGIN_OBJECT) {
            in.beginObject();
            b.append("{");
            do {
                if ((token = in.peek()) == JsonToken.NAME) {
                    b.append("\"");
                    b.append(in.nextName());
                    b.append("\":");
                    continue;
                }
                if (token == JsonToken.STRING) {
                    b.append("\"");
                    b.append(in.nextString());
                    b.append("\",");
                    continue;
                }
                if (token == JsonToken.BOOLEAN) {
                    b.append(in.nextBoolean());
                    continue;
                }
                if (token == JsonToken.NULL) {
                    b.append("null,");
                    continue;
                }
                if (token != JsonToken.NUMBER) continue;
                b.append(in.nextString());
                b.append(",");
            } while (token != JsonToken.END_OBJECT);
            in.endObject();
            b.deleteCharAt(b.length() - 1);
            b.append("}");
        }
        return b.toString();
    }
}

