/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class ZonedDateTimeAdapter
extends XmlAdapter<String, ZonedDateTime>
implements JsonSerializer<ZonedDateTime>,
JsonDeserializer<ZonedDateTime> {
    public ZonedDateTime unmarshal(String xml) throws Exception {
        return ZonedDateTime.parse(xml);
    }

    public String marshal(ZonedDateTime object) throws Exception {
        return object.toString();
    }

    public JsonElement serialize(ZonedDateTime src, Type srcType, JsonSerializationContext context) {
        return new JsonPrimitive(src.toString());
    }

    public ZonedDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
        if (jsonPrimitive.isString() && typeOfT.getTypeName().contains("ZonedDateTime")) {
            return ZonedDateTime.parse(jsonPrimitive.getAsString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
        if (jsonPrimitive.isNumber() && typeOfT.getTypeName().contains("ZonedDateTime")) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(jsonPrimitive.getAsLong()), ZoneId.systemDefault());
        }
        throw new JsonParseException("Unable to parse ZonedDateTime");
    }

    public String toJDBCDateTime(ZonedDateTime object) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:MM:SS").format(object);
    }

    public String fromJDBCDateTime(ZonedDateTime object) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:MM:SS").format(object);
    }
}

