/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.logger;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class EmbeddedFormatter
extends Formatter {
    private static final SimpleFormatter simple_formatter = new SimpleFormatter();
    private String print_break;
    private Boolean print_logger;
    private Boolean print_date;
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss.SSSSSS");

    public EmbeddedFormatter(String print_break, Boolean print_logger, Boolean print_date) {
        this.print_break = print_break;
        this.print_logger = print_logger;
        this.print_date = print_date;
        this.print_break = this.print_break == null || this.print_break.length() == 0 ? "\n" : "\n" + this.print_break + "\n";
    }

    @Override
    public String format(LogRecord record) {
        if (!this.print_logger.booleanValue() || !this.print_date.booleanValue()) {
            StringBuilder message = new StringBuilder(this.print_break);
            if (this.print_date.booleanValue()) {
                ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
                message.append(sdf.format(zdt));
            }
            if (message.length() > this.print_break.length()) {
                message.append(" ");
            }
            if (this.print_logger.booleanValue()) {
                Object source;
                if (record.getSourceClassName() != null) {
                    source = record.getSourceClassName();
                    if (record.getSourceMethodName() != null) {
                        source = (String)source + " " + record.getSourceMethodName();
                    }
                } else {
                    source = record.getLoggerName();
                }
                message.append((String)source);
            }
            if (message.length() > this.print_break.length()) {
                message.append("\n");
            }
            message.append(simple_formatter.formatMessage(record));
            if (record.getThrown() != null) {
                message.append("\n").append(simple_formatter.formatMessage(record)).append("\n");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                message.append(sw.toString());
                return message.toString();
            }
            return message.toString();
        }
        return simple_formatter.format(record);
    }
}

