/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.logger;

import java.io.File;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.reyadeyat.api.library.logger.EmbeddedFormatter;
import net.reyadeyat.api.library.logger.EmbeddedLevel;

public class EmbeddedLogger {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss.SSSSSS");

    private EmbeddedLogger() {
    }

    private static void handleLogger(String log_level, String print_break, Boolean print_logger, Boolean print_time, String log_path, String file_name) throws Exception {
        new File(log_path).mkdirs();
        String log_file = log_path + "/" + file_name + "." + sdf.format(Date.from(Instant.now().atZone(ZoneId.of("UTC")).toInstant())) + "." + UUID.randomUUID().toString() + ".log";
        EmbeddedLevel.init();
        FileHandler file_handler = new FileHandler(log_file);
        Files.deleteIfExists(new File(log_file + ".lck").toPath());
        if (print_logger.booleanValue() && print_time.booleanValue()) {
            file_handler.setFormatter(new SimpleFormatter());
        } else {
            file_handler.setFormatter(new EmbeddedFormatter(print_break, print_logger, print_time));
        }
        LogManager log_manager = LogManager.getLogManager();
        Iterator<String> logget_name_iterator = log_manager.getLoggerNames().asIterator();
        while (logget_name_iterator.hasNext()) {
            String logger_name = logget_name_iterator.next();
            Logger logger = Logger.getLogger(logger_name);
            logger.setUseParentHandlers(true);
            logger.setLevel(Level.parse(log_level));
            EmbeddedLogger.fixHandlers(logger, log_level, print_break, print_logger, print_time);
        }
        Logger root_logger = Logger.getLogger("");
        root_logger.setLevel(Level.parse(log_level));
        root_logger.setUseParentHandlers(false);
        EmbeddedLogger.fixHandlers(root_logger, log_level, print_break, print_logger, print_time);
        root_logger.addHandler(file_handler);
    }

    public static void fixHandlers(Logger logger, String log_level, String print_break, Boolean print_logger, Boolean print_time) throws Exception {
        for (Handler handler : logger.getHandlers()) {
            handler.setLevel(Level.parse(log_level));
            handler.setEncoding("UTF-8");
            if (handler instanceof FileHandler) {
                logger.removeHandler(handler);
                continue;
            }
            if (print_logger.booleanValue() && print_time.booleanValue()) continue;
            handler.setFormatter(new EmbeddedFormatter(print_break, print_logger, print_time));
        }
    }

    public static void build(final String app_name, final String log_level, final String print_break, final Boolean print_logger, final Boolean print_time, final String log_file_path) throws Exception {
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        System.setProperty(".level", log_level);
        System.setProperty("javax.net.debug", "info");
        System.setProperty("jdk.tls.client.enableSessionTicketExtension", "false");
        EmbeddedLogger.handleLogger(log_level, print_break, print_logger, print_time, log_file_path, app_name);
        Runnable logger_task = new Runnable(){

            @Override
            public void run() {
                try {
                    EmbeddedLogger.handleLogger(log_level, print_break, print_logger, print_time, log_file_path, app_name + ".log");
                }
                catch (Exception ex) {
                    Logger.getLogger(EmbeddedLogger.class.getName()).log(Level.SEVERE, "Logger Sechduled Task error", ex);
                }
            }
        };
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime midnight = now.toLocalDate().plusDays(1L).atStartOfDay();
        long initial_delay = Duration.between(now, midnight).toMinutes();
        long period = 1440L;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(logger_task, initial_delay, period, TimeUnit.MINUTES);
    }
}

