/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.security;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.reyadeyat.api.library.security.Security;

public class SecuredPipedReader
extends Reader {
    private Reader reader;
    private Writer piped_writer;
    private Security secutiry;
    private String separator;
    private StringBuilder buffer;

    public SecuredPipedReader(Reader reader, Security secutiry, String separator) {
        this(reader, null, secutiry, separator);
    }

    public SecuredPipedReader(Writer writer, Security secutiry, String separator) {
        this(null, writer, secutiry, separator);
    }

    public SecuredPipedReader(Reader reader, Writer piped_writer, Security secutiry, String separator) {
        this.reader = reader;
        this.piped_writer = piped_writer;
        this.secutiry = secutiry;
        this.separator = separator;
        this.buffer = new StringBuilder();
    }

    @Override
    public int read(char[] encypted_buffer, int offset, int length) throws IOException {
        try {
            this.buffer.append(encypted_buffer, offset, length);
            int index = -1;
            while ((index = this.buffer.indexOf(this.separator)) > -1) {
                String encrypted_text = this.buffer.substring(0, index);
                this.buffer.delete(0, index + this.separator.length());
                char[] plain_buffer = this.secutiry.decrypt_text(encrypted_text).toCharArray();
                if (this.piped_writer != null) {
                    this.piped_writer.write(plain_buffer, 0, plain_buffer.length);
                    return plain_buffer.length;
                }
                if (this.reader == null) continue;
                return this.reader.read(plain_buffer, 0, plain_buffer.length);
            }
            return 0;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void flush() throws IOException {
        if (this.piped_writer != null) {
            this.piped_writer.flush();
        }
    }
}

