/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.security;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.reyadeyat.api.library.security.Security;

public class SecuredPipedWriter
extends Writer {
    private Writer writer;
    private Reader piped_reader;
    private Security secutiry;
    private String separator;

    public SecuredPipedWriter(Writer writer, Security secutiry, String separator) throws Exception {
        this(writer, null, secutiry, separator);
    }

    public SecuredPipedWriter(Reader piped_reader, Security secutiry, String separator) throws Exception {
        this(null, piped_reader, secutiry, separator);
    }

    public SecuredPipedWriter(Writer writer, Reader piped_reader, Security secutiry, String separator) throws Exception {
        this.writer = writer;
        this.piped_reader = piped_reader;
        this.secutiry = secutiry;
        this.separator = separator;
        if (this.writer == null) {
            throw new Exception("writer is null");
        }
    }

    @Override
    public void write(char[] plain_buffer, int offset, int length) throws IOException {
        try {
            char[] encrypted_buffer = (this.secutiry.encrypt_text(new String(plain_buffer, offset, length)) + this.separator).toCharArray();
            if (this.piped_reader != null) {
                this.piped_reader.read(encrypted_buffer, 0, encrypted_buffer.length);
            }
            if (this.writer != null) {
                this.writer.write(encrypted_buffer, 0, encrypted_buffer.length);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

