/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.security;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.reyadeyat.api.library.security.Security;

public class SecurityAES
implements Security {
    private static final String ALPHANUMERIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final String ALPHABETIC = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private int key_length;
    private byte[] encryption_key;
    private byte[] encryption_key_iv_spec;
    private Cipher encrypt_cipher;
    private Cipher decrypt_cipher;

    public SecurityAES() throws Exception {
        this(16);
    }

    public SecurityAES(int key_length) throws Exception {
        this(key_length, SecurityAES.generate_random_key(key_length).getBytes(StandardCharsets.US_ASCII), SecurityAES.generate_random_key(key_length).getBytes(StandardCharsets.US_ASCII));
    }

    public SecurityAES(int key_length, byte[] encryption_key, byte[] encryption_key_iv_spec) throws Exception {
        if (encryption_key == null) {
            throw new Exception("encryption_key is null!");
        }
        if (encryption_key_iv_spec == null) {
            throw new Exception("encryption_key_iv_spec is null!");
        }
        if (encryption_key.length != key_length) {
            throw new Exception("encryption_key.length [" + encryption_key.length + "] != key_length [" + key_length + "]");
        }
        if (encryption_key_iv_spec.length != key_length) {
            throw new Exception("encryption_key_iv_spec.length [" + encryption_key_iv_spec.length + "] != key_length [" + key_length + "]");
        }
        this.key_length = key_length;
        this.encryption_key = encryption_key;
        this.encryption_key_iv_spec = encryption_key_iv_spec;
        this.encrypt_cipher = this.create_encrypt_cipher(this.encryption_key, this.encryption_key_iv_spec);
        this.decrypt_cipher = this.create_decrypt_cipher(this.encryption_key, this.encryption_key_iv_spec);
    }

    public SecurityAES(Cipher cipher, Boolean encrypt) throws Exception {
        this(encrypt != false ? cipher : null, encrypt == false ? cipher : null);
    }

    public SecurityAES(Cipher encrypt_cipher, Cipher decrypt_cipher) throws Exception {
        this.encrypt_cipher = encrypt_cipher;
        this.decrypt_cipher = decrypt_cipher;
    }

    @Override
    public String encrypt_text(String plain_text) throws Exception {
        byte[] encrypted_text_bytes = this.encrypt_cipher.doFinal(plain_text.getBytes("UTF-8"));
        String encrypted_text = Base64.getEncoder().encodeToString(encrypted_text_bytes);
        return encrypted_text;
    }

    @Override
    public String decrypt_text(String encrypted_text) throws Exception {
        byte[] encrypted_text_base64_bytes = Base64.getDecoder().decode(encrypted_text);
        if (encrypted_text_base64_bytes.length % 16 != 0) {
            throw new Exception("encrypted_text_base64_bytes " + encrypted_text_base64_bytes.length + " % 16 = " + encrypted_text_base64_bytes.length % 16);
        }
        byte[] plain_text_bytes = this.decrypt_cipher.doFinal(encrypted_text_base64_bytes);
        String plain_text = new String(plain_text_bytes);
        return plain_text;
    }

    public static String generate_random_key(int length) {
        String possibleDigits = SecurityAES.shuffle(ALPHANUMERIC);
        StringBuilder randomNumber = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt(possibleDigits.length());
            char randomChar = possibleDigits.charAt(randomIndex);
            randomNumber.append(randomChar);
        }
        return randomNumber.toString();
    }

    private Cipher create_encrypt_cipher(byte[] encryption_key, byte[] encryption_key_iv_spec) throws Exception {
        this.encrypt_cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        SecretKeySpec secretKeySpec = new SecretKeySpec(encryption_key, "AES");
        IvParameterSpec paramSpec = new IvParameterSpec(encryption_key_iv_spec);
        this.encrypt_cipher.init(1, (Key)secretKeySpec, paramSpec);
        return this.encrypt_cipher;
    }

    private Cipher create_decrypt_cipher(byte[] encryption_key, byte[] encryption_key_iv_spec) throws Exception {
        IvParameterSpec iv = new IvParameterSpec(encryption_key_iv_spec);
        if (encryption_key.length % 16 != 0) {
            throw new Exception("encryption_key " + encryption_key.length + " % 16 = " + encryption_key.length % 16);
        }
        SecretKeySpec skeySpec = new SecretKeySpec(encryption_key, "AES");
        this.decrypt_cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        this.decrypt_cipher.init(2, (Key)skeySpec, iv);
        return this.decrypt_cipher;
    }

    public static String shuffle(String content) {
        StringBuilder string = new StringBuilder(content);
        Random random = new Random();
        for (int i = string.length() - 1; i > 0; --i) {
            int randomIndex = random.nextInt(string.length() - 1);
            char temp = string.charAt(i);
            string.setCharAt(i, string.charAt(randomIndex));
            string.setCharAt(randomIndex, temp);
        }
        return string.toString();
    }

    public static String encrypt_method(Integer method_id, String key, String vi) {
        StringBuilder method_key = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            StringBuilder word = new StringBuilder("" + key.charAt(i) * vi.charAt(i));
            while (word.length() < 5) {
                word.insert(0, "0");
            }
            if (i % 2 == 0) {
                word.append((int)key.charAt(i));
            } else {
                word.append((int)vi.charAt(i));
            }
            while (word.length() < 8) {
                word.insert(5, "0");
            }
            method_key.append((CharSequence)word);
        }
        SecurityAES.replace_zeros(method_key, SecurityAES.shuffle(ALPHABETIC));
        return method_key.toString();
    }

    public static void decrypt_method(Integer method_id, String method_key, StringBuilder key, StringBuilder vi) {
        StringBuilder m_key = new StringBuilder(method_key);
        SecurityAES.replace_letters(m_key);
        method_key = m_key.toString();
        for (int i = 0; i < 128; i += 8) {
            Integer low = Integer.valueOf(method_key.substring(i, i + 5));
            Integer hight = Integer.valueOf(method_key.substring(i + 5, i + 8));
            if (i / 8 % 2 == 0) {
                key.append((char)hight.intValue());
                vi.append((char)(low / hight));
                continue;
            }
            vi.append((char)hight.intValue());
            key.append((char)(low / hight));
        }
    }

    public static void replace_zeros(StringBuilder input_string, String finite_string) {
        Random random = new Random();
        for (int i = 0; i < input_string.length(); ++i) {
            if (input_string.charAt(i) != '0') continue;
            char random_char = finite_string.charAt(random.nextInt(finite_string.length()));
            input_string.replace(i, i + 1, "" + random_char);
        }
    }

    public static void replace_letters(StringBuilder input_string) {
        for (int i = 0; i < input_string.length(); ++i) {
            if (input_string.charAt(i) < ':') continue;
            input_string.replace(i, i + 1, "0");
        }
    }
}

