/*
 * Decompiled with CFR 0.152.
 */
package net.reyadeyat.api.library.sequence;

import java.util.Arrays;
import java.util.HashMap;
import net.reyadeyat.api.library.sequence.Sequence;

public class SequenceString
implements Sequence<String> {
    private HashMap<Class, SequenceStringItem> sequenceClassMap;
    private char[] ordered_sequence;
    private Integer sequence_base;
    private Integer chars_width;
    private char padding_char;
    private Boolean rewind;
    private Boolean synchronize;

    public SequenceString(char[] ordered_sequence, Integer chars_width, char padding_char, Boolean rewind, Boolean synchronize) throws Exception {
        this.ordered_sequence = ordered_sequence;
        this.sequence_base = this.ordered_sequence.length - 1;
        this.chars_width = chars_width;
        Arrays.sort(this.ordered_sequence);
        this.padding_char = padding_char;
        this.rewind = rewind;
        this.synchronize = synchronize;
        this.sequenceClassMap = new HashMap();
        for (int i = 0; i < this.ordered_sequence.length; ++i) {
            if (this.padding_char > this.ordered_sequence[i]) {
                throw new Exception("padding char must be lower any char in the ordered sequence char array");
            }
            if (i >= this.ordered_sequence.length - 1 || this.ordered_sequence[i] != this.ordered_sequence[i + 1]) continue;
            throw new Exception("Sequence must has unique chars found char[" + i + "] '" + this.ordered_sequence[i] + "' equals char[" + (i + 1) + "] '" + this.ordered_sequence[i + 1] + "' must be lower any char in the ordered sequence char array");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSequence(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceStringItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                if (this.sequenceClassMap.containsKey(clas)) {
                    throw new Exception("Sequence Class '" + clas.getCanonicalName() + "' already created");
                }
                this.sequenceClassMap.put(clas, new SequenceStringItem());
            }
        }
        if (this.sequenceClassMap.containsKey(clas)) {
            throw new Exception("Sequence Class '" + clas.getCanonicalName() + "' already created");
        }
        this.sequenceClassMap.put(clas, new SequenceStringItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initSequence(Class clas, String value) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceStringItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                if (!this.sequenceClassMap.containsKey(clas)) {
                    throw new Exception("Sequence Class '" + clas.getCanonicalName() + "' is not exist");
                }
                this.sequenceClassMap.get(clas).initSequence(value);
            }
        }
        if (!this.sequenceClassMap.containsKey(clas)) {
            throw new Exception("Sequence Class '" + clas.getCanonicalName() + "' is not exist");
        }
        this.sequenceClassMap.get(clas).initSequence(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean hasSequence(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceStringItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                return this.sequenceClassMap.containsKey(clas);
            }
        }
        return this.sequenceClassMap.containsKey(clas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends String> T nextSequence(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        SequenceStringItem ss = this.sequenceClassMap.get(clas);
        if (ss == null) {
            throw new NullPointerException("Class '" + String.valueOf(clas) + "' is not defined in this sequence");
        }
        if (this.synchronize.booleanValue()) {
            SequenceStringItem sequenceStringItem = ss;
            synchronized (sequenceStringItem) {
                return (T)ss.nextSequence();
            }
        }
        return (T)ss.nextSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends String> T getSequenceState(Class clas) throws Exception {
        if (clas == null) {
            throw new Exception("Sequence Class can not be null value");
        }
        SequenceStringItem ss = this.sequenceClassMap.get(clas);
        if (ss == null) {
            throw new NullPointerException("Class '" + String.valueOf(clas) + "' is not defined in this sequence");
        }
        if (this.synchronize.booleanValue()) {
            SequenceStringItem sequenceStringItem = ss;
            synchronized (sequenceStringItem) {
                return (T)ss.getLastSequenceIssued();
            }
        }
        return (T)ss.getLastSequenceIssued();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends String> HashMap<Class, T> getSequenceState() throws Exception {
        if (this.synchronize.booleanValue()) {
            HashMap<Class, SequenceStringItem> hashMap = this.sequenceClassMap;
            synchronized (hashMap) {
                HashMap<Class, String> sequenceClassMapState = new HashMap<Class, String>();
                for (Class key : this.sequenceClassMap.keySet()) {
                    sequenceClassMapState.put(key, this.sequenceClassMap.get(key).getLastSequenceIssued());
                }
                return sequenceClassMapState;
            }
        }
        HashMap<Class, String> sequenceClassMapState = new HashMap<Class, String>();
        for (Class key : this.sequenceClassMap.keySet()) {
            sequenceClassMapState.put(key, this.sequenceClassMap.get(key).getLastSequenceIssued());
        }
        return sequenceClassMapState;
    }

    public static void main(String[] args) {
        try {
            SequenceString sequenceString;
            Boolean debug_sequence_number_add_circuite = false;
            char padding_char = '0';
            char[] numeric_sequence = "0123456789".toCharArray();
            char[] alphanumeric_sequence = "abcdef0123456789".toCharArray();
            SequenceString sequence = sequenceString = new SequenceString(alphanumeric_sequence, 6, padding_char, false, false);
            sequence.createSequence(SequenceString.class);
            Integer counter = 0;
            Integer debug = 0;
            while (true) {
                String id = (String)sequence.nextSequence(SequenceString.class);
                System.out.println(counter + "-" + Integer.parseInt(id, 16) + "-" + id);
                if (debug_sequence_number_add_circuite.booleanValue() && Integer.parseInt(id, 16) != counter) {
                    throw new Exception("Failed to debug");
                }
                Integer n = counter;
                counter = counter + 1;
                if (!debug_sequence_number_add_circuite.booleanValue() || counter != 65535) continue;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return;
        }
    }

    private class SequenceStringItem {
        char[] sequence_chars;
        Integer[] sequence_chars_cursors;
        Integer sliding_cursor;
        Integer counterCursor;

        public SequenceStringItem() {
            this.sliding_cursor = SequenceString.this.chars_width - 1;
            this.counterCursor = 0;
            this.sequence_chars = new char[SequenceString.this.chars_width.intValue()];
            this.sequence_chars_cursors = new Integer[SequenceString.this.chars_width.intValue()];
            for (int i = 0; i < SequenceString.this.chars_width; ++i) {
                this.sequence_chars_cursors[i] = 0;
                this.sequence_chars[i] = SequenceString.this.padding_char;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String nextSequence() throws Exception {
            if (this.counterCursor <= SequenceString.this.sequence_base) {
                Integer n = this.counterCursor;
                this.counterCursor = this.counterCursor + 1;
                Integer n2 = n;
                this.sequence_chars_cursors[SequenceString.this.chars_width.intValue() - 1] = n2;
                this.sequence_chars[SequenceString.this.chars_width.intValue() - 1] = SequenceString.this.ordered_sequence[n2];
                return new String(this.sequence_chars);
            } else {
                int i;
                this.counterCursor = 1;
                Integer carry_out = 1;
                for (i = SequenceString.this.chars_width - 1; i > this.sliding_cursor - carry_out && carry_out == 1; --i) {
                    if (this.sequence_chars_cursors[i] == SequenceString.this.sequence_base) {
                        this.sequence_chars_cursors[i] = 0;
                        this.sequence_chars[i] = SequenceString.this.ordered_sequence[this.sequence_chars_cursors[i]];
                        carry_out = 1;
                        continue;
                    }
                    Integer[] integerArray = this.sequence_chars_cursors;
                    int n = i;
                    integerArray[n] = integerArray[n] + 1;
                    this.sequence_chars[i] = SequenceString.this.ordered_sequence[integerArray[n]];
                    carry_out = 0;
                }
                this.sliding_cursor = this.sliding_cursor - carry_out;
                if (this.sliding_cursor == -1) {
                    if (!SequenceString.this.rewind.booleanValue()) throw new Exception("Buffer Overflow; Sequence is full; rewind is disabled.");
                    this.sliding_cursor = SequenceString.this.chars_width - 1;
                    this.counterCursor = 0;
                    for (i = 0; i < SequenceString.this.chars_width; ++i) {
                        this.sequence_chars_cursors[i] = 0;
                        this.sequence_chars[i] = SequenceString.this.padding_char;
                    }
                    Integer n = this.counterCursor;
                    this.counterCursor = this.counterCursor + 1;
                    Integer n3 = n;
                    this.sequence_chars_cursors[this.sliding_cursor.intValue()] = n3;
                    this.sequence_chars[this.sliding_cursor.intValue()] = SequenceString.this.ordered_sequence[n3];
                    return new String(this.sequence_chars);
                } else {
                    if (carry_out <= 0) return new String(this.sequence_chars);
                    Integer n = 1;
                    this.sequence_chars_cursors[this.sliding_cursor.intValue()] = n;
                    this.sequence_chars[this.sliding_cursor.intValue()] = SequenceString.this.ordered_sequence[n];
                }
            }
            return new String(this.sequence_chars);
        }

        public void initSequence(String value) throws Exception {
            if (value.length() > SequenceString.this.chars_width) {
                throw new Exception("Length of initial sequence value '" + value + "' is greater than accepted with[" + SequenceString.this.chars_width + "]");
            }
            for (int i = 0; i < SequenceString.this.ordered_sequence.length; ++i) {
                if (value.indexOf(SequenceString.this.ordered_sequence[i]) != -1) continue;
                throw new Exception("initial sequence value char[" + i + "]='" + SequenceString.this.ordered_sequence[i] + "' is not in the set of accepted chars " + new String(SequenceString.this.ordered_sequence));
            }
            this.counterCursor = 1;
            Integer carry_out = 1;
            for (int i = SequenceString.this.chars_width - 1; i > this.sliding_cursor - carry_out && carry_out == 1; --i) {
                if (this.sequence_chars_cursors[i] == SequenceString.this.sequence_base) {
                    this.sequence_chars_cursors[i] = 0;
                    this.sequence_chars[i] = SequenceString.this.ordered_sequence[this.sequence_chars_cursors[i]];
                    carry_out = 1;
                    continue;
                }
                Integer[] integerArray = this.sequence_chars_cursors;
                int n = i;
                integerArray[n] = integerArray[n] + 1;
                this.sequence_chars[i] = SequenceString.this.ordered_sequence[integerArray[n]];
                carry_out = 0;
            }
        }

        public String getLastSequenceIssued() {
            return new String(this.sequence_chars);
        }
    }
}

